/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.thread.impl;

import java.util.concurrent.ThreadFactory;
import org.hibernate.search.engine.environment.thread.impl.SimpleThreadFactory;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;

public final class DefaultThreadProvider
implements ThreadProvider {
    private final String commonThreadNamePrefix;

    public DefaultThreadProvider() {
        this("Hibernate Search - ");
    }

    public DefaultThreadProvider(String commonThreadNamePrefix) {
        this.commonThreadNamePrefix = commonThreadNamePrefix;
    }

    @Override
    public String createThreadName(String prefix, int threadNumber) {
        return this.createFullThreadNamePrefix(prefix) + threadNumber;
    }

    @Override
    public ThreadFactory createThreadFactory(String prefix) {
        SecurityManager s = System.getSecurityManager();
        ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        String namePrefix = this.createFullThreadNamePrefix(prefix);
        return new SimpleThreadFactory(group, namePrefix);
    }

    private String createFullThreadNamePrefix(String prefix) {
        return this.commonThreadNamePrefix + prefix + " - ";
    }
}

