/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.impl;

import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;

final class BeanProviderOnlyBeanResolver
implements BeanResolver {
    private final BeanProvider beanProvider;

    BeanProviderOnlyBeanResolver(BeanProvider beanProvider) {
        this.beanProvider = beanProvider;
    }

    @Override
    public <T> BeanHolder<T> resolve(Class<T> typeReference) {
        Contracts.assertNotNull(typeReference, (String)"typeReference");
        return this.beanProvider.forType(typeReference);
    }

    @Override
    public <T> BeanHolder<T> resolve(Class<T> typeReference, String nameReference) {
        Contracts.assertNotNull(typeReference, (String)"typeReference");
        Contracts.assertNotNullNorEmpty((String)nameReference, (String)"nameReference");
        return this.beanProvider.forTypeAndName(typeReference, nameReference);
    }

    @Override
    public <T> List<BeanReference<T>> allConfiguredForRole(Class<T> role) {
        throw new AssertionFailure("Unexpected call to allConfiguredForRole(...) before roles are even defined.");
    }

    @Override
    public <T> Map<String, BeanReference<T>> namedConfiguredForRole(Class<T> role) {
        throw new AssertionFailure("Unexpected call to namedConfiguredForRole(...) before roles are even defined.");
    }
}

