/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.orchestration.spi;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.hibernate.search.engine.backend.orchestration.spi.BatchedWork;
import org.hibernate.search.engine.backend.orchestration.spi.BatchedWorkProcessor;
import org.hibernate.search.engine.backend.orchestration.spi.SingletonTask;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class BatchingExecutor<P extends BatchedWorkProcessor> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final FailureHandler failureHandler;
    private final BlockingQueue<BatchedWork<? super P>> workQueue;
    private final BatchWorker<P> worker;
    private SingletonTask processingTask;

    public BatchingExecutor(String name, P processor, int maxTasksPerBatch, boolean fair, FailureHandler failureHandler) {
        this.name = name;
        this.failureHandler = failureHandler;
        this.workQueue = new ArrayBlockingQueue<BatchedWork<? super P>>(maxTasksPerBatch, fair);
        this.worker = new BatchWorker(name, (BatchedWorkProcessor)processor, this.workQueue, maxTasksPerBatch, null);
    }

    public String toString() {
        return "BatchingExecutor[name=" + this.name + ", queue size=" + this.workQueue.size() + ", processing=" + this.processingTask + "]";
    }

    public synchronized void start(ExecutorService executorService) {
        log.startingExecutor(this.name);
        this.processingTask = new SingletonTask(this.name, this.worker, new BatchScheduler(executorService), this.failureHandler);
    }

    public synchronized void stop() {
        log.stoppingExecutor(this.name);
        this.workQueue.clear();
        this.processingTask.stop();
        this.processingTask = null;
    }

    public void submit(BatchedWork<? super P> work) throws InterruptedException {
        if (this.processingTask == null) {
            throw new AssertionFailure("Attempt to submit a work to executor '" + this.name + "', which is stopped.");
        }
        this.workQueue.put(work);
        this.processingTask.ensureScheduled();
    }

    public CompletableFuture<?> completion() {
        if (this.processingTask == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.processingTask.completion();
    }

    private static final class BatchScheduler
    implements SingletonTask.Scheduler {
        private final ExecutorService delegate;

        public BatchScheduler(ExecutorService delegate) {
            this.delegate = delegate;
        }

        @Override
        public Future<?> schedule(Runnable runnable) {
            return this.delegate.submit(runnable);
        }
    }

    private static final class BatchWorker<P extends BatchedWorkProcessor>
    implements SingletonTask.Worker {
        private final CompletableFuture<?> completedFuture = CompletableFuture.completedFuture(null);
        private final String name;
        private final P processor;
        private final BlockingQueue<BatchedWork<? super P>> workQueue;
        private final int maxTasksPerBatch;
        private final List<BatchedWork<? super P>> workBuffer;

        private BatchWorker(String name, P processor, BlockingQueue<BatchedWork<? super P>> workQueue, int maxTasksPerBatch) {
            this.name = name;
            this.processor = processor;
            this.workQueue = workQueue;
            this.maxTasksPerBatch = maxTasksPerBatch;
            this.workBuffer = new ArrayList<BatchedWork<? super P>>(maxTasksPerBatch);
        }

        @Override
        public CompletableFuture<?> work() {
            this.workBuffer.clear();
            this.workQueue.drainTo(this.workBuffer, this.maxTasksPerBatch);
            if (this.workBuffer.isEmpty()) {
                return this.completedFuture;
            }
            int workCount = this.workBuffer.size();
            boolean debugEnabled = log.isDebugEnabled();
            if (debugEnabled) {
                log.debugf("Processing %d works in executor '%s'", workCount, this.name);
            }
            this.processor.beginBatch();
            for (BatchedWork<P> work : this.workBuffer) {
                try {
                    work.submitTo(this.processor);
                }
                catch (Throwable e) {
                    work.markAsFailed(e);
                }
            }
            CompletableFuture<?> future = this.processor.endBatch();
            if (debugEnabled) {
                future.whenComplete((result, throwable) -> log.debugf("Processed %d works in executor '%s'", workCount, this.name));
            }
            return future;
        }

        @Override
        public void complete() {
            this.processor.complete();
        }

        /* synthetic */ BatchWorker(String x0, BatchedWorkProcessor x1, BlockingQueue x2, int x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }
}

