/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.aggregation;

import java.util.Objects;
import org.hibernate.search.util.common.impl.Contracts;

public final class AggregationKey<A> {
    private final String name;

    public static <A> AggregationKey<A> of(String name) {
        Contracts.assertNotNullNorEmpty((String)name, (String)"name");
        return new AggregationKey<A>(name);
    }

    private AggregationKey(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationKey that = (AggregationKey)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String name() {
        return this.name;
    }

    @Deprecated
    public String getName() {
        return this.name();
    }
}

