/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.cfg.impl.ConfigurationPropertySourceExtractor;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class EngineConfigurationUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private EngineConfigurationUtils() {
    }

    public static ConfigurationPropertySourceExtractor extractorForBackend(Optional<String> backendNameOptional, String defaultBackendName) {
        if (!backendNameOptional.isPresent()) {
            if (defaultBackendName == null) {
                return engineSource -> engineSource.withMask("backend");
            }
            return engineSource -> engineSource.withMask("backend").withFallback(engineSource.withMask("backends").withMask(defaultBackendName));
        }
        return engineSource -> engineSource.withMask("backends").withMask((String)backendNameOptional.get());
    }

    public static ConfigurationPropertySourceExtractor extractorForIndex(ConfigurationPropertySourceExtractor extractorForBackend, String indexName) {
        return engineSource -> {
            ConfigurationPropertySource backendSource = extractorForBackend.extract(engineSource);
            return backendSource.withMask("indexes").withMask(indexName).withFallback(backendSource).withFallback(backendSource.withMask("index_defaults").onGet(log::deprecatedIndexDefaultsPrefix));
        };
    }
}

