/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.spi;

import java.util.function.Consumer;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.sort.dsl.CompositeSortComponentsStep;
import org.hibernate.search.engine.search.sort.dsl.DistanceSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.ExtendedSearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.FieldSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.ScoreSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtension;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtensionIfSupportedStep;
import org.hibernate.search.engine.search.sort.dsl.SortThenStep;
import org.hibernate.search.engine.search.sort.dsl.impl.DistanceSortOptionsStepImpl;
import org.hibernate.search.engine.search.sort.dsl.impl.FieldSortOptionsStepImpl;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.spatial.GeoPoint;

public class DelegatingSearchSortFactory<PDF extends SearchPredicateFactory>
implements ExtendedSearchSortFactory<PDF> {
    private final SearchSortFactory delegate;
    private final SearchSortDslContext<?, ?, ? extends PDF> dslContext;

    public DelegatingSearchSortFactory(SearchSortFactory delegate, SearchSortDslContext<?, ?, ? extends PDF> dslContext) {
        this.delegate = delegate;
        this.dslContext = dslContext;
    }

    @Override
    public ScoreSortOptionsStep<?> score() {
        return this.delegate.score();
    }

    @Override
    public SortThenStep indexOrder() {
        return this.delegate.indexOrder();
    }

    @Override
    public FieldSortOptionsStep<?, PDF> field(String absoluteFieldPath) {
        return new FieldSortOptionsStepImpl(this.dslContext, absoluteFieldPath);
    }

    @Override
    public DistanceSortOptionsStep<?, PDF> distance(String absoluteFieldPath, GeoPoint location) {
        return new DistanceSortOptionsStepImpl(this.dslContext, absoluteFieldPath, location);
    }

    @Override
    public CompositeSortComponentsStep<?> composite() {
        return this.delegate.composite();
    }

    @Override
    public SortThenStep composite(Consumer<? super CompositeSortComponentsStep<?>> elementContributor) {
        return this.delegate.composite(elementContributor);
    }

    @Override
    public <T> T extension(SearchSortFactoryExtension<T> extension) {
        return this.delegate.extension(extension);
    }

    @Override
    public SearchSortFactoryExtensionIfSupportedStep extension() {
        return this.delegate.extension();
    }

    protected SearchSortFactory delegate() {
        return this.delegate;
    }
}

