/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.impl;

import java.util.function.Consumer;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.sort.dsl.CompositeSortComponentsStep;
import org.hibernate.search.engine.search.sort.dsl.DistanceSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.ScoreSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtension;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtensionIfSupportedStep;
import org.hibernate.search.engine.search.sort.dsl.SortThenStep;
import org.hibernate.search.engine.search.sort.dsl.impl.CompositeSortComponentsStepImpl;
import org.hibernate.search.engine.search.sort.dsl.impl.DistanceSortOptionsStepImpl;
import org.hibernate.search.engine.search.sort.dsl.impl.FieldSortOptionsStepImpl;
import org.hibernate.search.engine.search.sort.dsl.impl.ScoreSortOptionsStepImpl;
import org.hibernate.search.engine.search.sort.dsl.impl.SearchSortFactoryExtensionStep;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.dsl.spi.StaticSortThenStep;
import org.hibernate.search.engine.spatial.GeoPoint;

public class DefaultSearchSortFactory<B>
implements SearchSortFactory {
    private final SearchSortDslContext<?, B, ?> dslContext;

    public DefaultSearchSortFactory(SearchSortDslContext<?, B, ?> dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public ScoreSortOptionsStep<?> score() {
        return new ScoreSortOptionsStepImpl<B>(this.dslContext);
    }

    @Override
    public SortThenStep indexOrder() {
        return this.staticThenStep(this.dslContext.builderFactory().indexOrder());
    }

    @Override
    public FieldSortOptionsStep<?, ? extends SearchPredicateFactory> field(String absoluteFieldPath) {
        return new FieldSortOptionsStepImpl(this.dslContext, absoluteFieldPath);
    }

    @Override
    public DistanceSortOptionsStep<?, ? extends SearchPredicateFactory> distance(String absoluteFieldPath, GeoPoint location) {
        return new DistanceSortOptionsStepImpl(this.dslContext, absoluteFieldPath, location);
    }

    @Override
    public CompositeSortComponentsStep<?> composite() {
        return new CompositeSortComponentsStepImpl<B>(this.dslContext);
    }

    @Override
    public SortThenStep composite(Consumer<? super CompositeSortComponentsStep<?>> elementContributor) {
        CompositeSortComponentsStep<?> next = this.composite();
        elementContributor.accept(next);
        return next;
    }

    @Override
    public <T> T extension(SearchSortFactoryExtension<T> extension) {
        return DslExtensionState.returnIfSupported(extension, extension.extendOptional(this, this.dslContext));
    }

    @Override
    public SearchSortFactoryExtensionIfSupportedStep extension() {
        return new SearchSortFactoryExtensionStep<B>(this, this.dslContext);
    }

    private SortThenStep staticThenStep(B builder) {
        return new StaticSortThenStep<B>(this.dslContext, builder);
    }
}

