/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.spi;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.engine.search.query.spi.SearchQueryImplementor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractSearchQuery<H, R extends SearchResult<H>>
implements SearchQueryImplementor<H> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.queryString() + ")";
    }

    public R fetchAll() {
        return this.fetch(null, null);
    }

    public R fetch(Integer limit) {
        return this.fetch(null, limit);
    }

    public abstract R fetch(Integer var1, Integer var2);

    @Override
    public List<H> fetchAllHits() {
        return this.fetchHits(null, null);
    }

    @Override
    public List<H> fetchHits(Integer limit) {
        return this.fetchHits(null, limit);
    }

    @Override
    public List<H> fetchHits(Integer offset, Integer limit) {
        return this.fetch(offset, limit).hits();
    }

    @Override
    public Optional<H> fetchSingleHit() {
        R result = this.fetch(2);
        List hits = result.hits();
        int fetchedHitCount = result.hits().size();
        if (fetchedHitCount == 0) {
            return Optional.empty();
        }
        if (fetchedHitCount > 1) {
            throw log.nonSingleHit(result.totalHitCount());
        }
        return Optional.of(hits.get(0));
    }
}

