/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.loading.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class DefaultProjectionHitMapper<R, E>
implements ProjectionHitMapper<R, E> {
    private final DocumentReferenceConverter<R> documentReferenceConverter;
    private final EntityLoader<R, ? extends E> objectLoader;
    private final List<R> referencesToLoad = new ArrayList<R>();

    public DefaultProjectionHitMapper(DocumentReferenceConverter<R> documentReferenceConverter, EntityLoader<R, ? extends E> objectLoader) {
        this.documentReferenceConverter = documentReferenceConverter;
        this.objectLoader = objectLoader;
    }

    @Override
    public R convertReference(DocumentReference reference) {
        return this.documentReferenceConverter.fromDocumentReference(reference);
    }

    @Override
    public Object planLoading(DocumentReference reference) {
        this.referencesToLoad.add(this.documentReferenceConverter.fromDocumentReference(reference));
        return this.referencesToLoad.size() - 1;
    }

    @Override
    public LoadingResult<E> loadBlocking() {
        return new DefaultLoadingResult(this.objectLoader.loadBlocking(this.referencesToLoad));
    }

    private static class DefaultLoadingResult<E>
    implements LoadingResult<E> {
        private final List<? extends E> loadedObjects;

        private DefaultLoadingResult(List<? extends E> loadedObjects) {
            this.loadedObjects = CollectionHelper.toImmutableList(loadedObjects);
        }

        @Override
        public E get(Object key) {
            return this.loadedObjects.get((Integer)key);
        }
    }
}

