/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

class DepthFilter {
    private static final DepthFilter UNCONSTRAINED = new DepthFilter(null);
    private final Integer maxDepth;

    static DepthFilter unconstrained() {
        return UNCONSTRAINED;
    }

    static DepthFilter of(Integer maxDepth) {
        return new DepthFilter(maxDepth);
    }

    private DepthFilter(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[maxDepth=" + this.maxDepth + "]";
    }

    boolean isEveryPathIncludedAtDepth(int relativeDepth) {
        return this.maxDepth == null || this.maxDepth > relativeDepth;
    }

    boolean hasDepthLimit() {
        return this.maxDepth != null;
    }
}

