/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.impl.EngineConfigurationUtils;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.impl.BackendStartContextImpl;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.impl.RootFailureCollector;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;

class BackendPartialBuildState {
    private final String backendName;
    private final BackendImplementor<?> partiallyBuiltBackend;

    BackendPartialBuildState(String backendName, BackendImplementor<?> partiallyBuiltBackend) {
        this.backendName = backendName;
        this.partiallyBuiltBackend = partiallyBuiltBackend;
    }

    void closeOnFailure() {
        this.partiallyBuiltBackend.stop();
    }

    BackendImplementor<?> finalizeBuild(RootFailureCollector rootFailureCollector, BeanResolver beanResolver, ConfigurationPropertySource rootPropertySource) {
        ContextualFailureCollector backendFailureCollector = rootFailureCollector.withContext(EventContexts.fromBackendName(this.backendName));
        ConfigurationPropertySource backendPropertySource = EngineConfigurationUtils.getBackend(rootPropertySource, this.backendName);
        BackendStartContextImpl startContext = new BackendStartContextImpl(backendFailureCollector, beanResolver, backendPropertySource);
        try {
            this.partiallyBuiltBackend.start(startContext);
        }
        catch (RuntimeException e) {
            backendFailureCollector.add(e);
        }
        return this.partiallyBuiltBackend;
    }
}

