package org.hibernate.search.engine.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.jboss.logging.BasicLogger;
import java.util.Collection;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.List;
import java.util.Arrays;
import java.time.format.DateTimeFormatter;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void version(final String versionString) {
        super.log.logf(FQCN, INFO, null, version$str(), versionString);
    }
    protected String version$str() {
        return "HSEARCH000034: Hibernate Search {%1$s}";
    }
    @Override
    public final void startingExecutor(final String name) {
        super.log.logf(FQCN, DEBUG, null, startingExecutor$str(), name);
    }
    protected String startingExecutor$str() {
        return "HSEARCH000230: Starting executor '%1$s'";
    }
    @Override
    public final void stoppingExecutor(final String indexName) {
        super.log.logf(FQCN, DEBUG, null, stoppingExecutor$str(), indexName);
    }
    protected String stoppingExecutor$str() {
        return "HSEARCH000231: Stopping executor '%1$s'";
    }
    protected String noPublicNoArgConstructor$str() {
        return "HSEARCH000242: Hibernate Search failed to initialize component '%1$s' as class '%2$s' doesn't have a public no-arguments constructor";
    }
    @Override
    public final SearchException noPublicNoArgConstructor(final String componentName, final Class<?> clazz) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noPublicNoArgConstructor$str(), componentName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(clazz)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String simpleQueryStringCannotBeNull$str() {
        return "HSEARCH000334: Invalid simple query string: the string must be non-null. Null value was passed to simple query string predicate on fields %1$s.";
    }
    @Override
    public final SearchException simpleQueryStringCannotBeNull(final Collection<String> strings) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), simpleQueryStringCannotBeNull$str(), strings));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToConvertConfigurationProperty$str() {
        return "HSEARCH000501: Unable to convert configuration property '%1$s' with value '%2$s': %3$s";
    }
    @Override
    public final SearchException unableToConvertConfigurationProperty(final String key, final Object rawValue, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToConvertConfigurationProperty$str(), key, rawValue, errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPropertyValue$str() {
        return "HSEARCH000502: Invalid value: expected either an instance of '%1$s' or a String that can be parsed. %2$s";
    }
    @Override
    public final SearchException invalidPropertyValue(final Class<?> expectedType, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPropertyValue$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedType), errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBooleanPropertyValue$str() {
        return "HSEARCH000503: Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s";
    }
    @Override
    public final SearchException invalidBooleanPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBooleanPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIntegerPropertyValue$str() {
        return "HSEARCH000504: Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s";
    }
    @Override
    public final SearchException invalidIntegerPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIntegerPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidLongPropertyValue$str() {
        return "HSEARCH000505: Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s";
    }
    @Override
    public final SearchException invalidLongPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidLongPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMultiPropertyValue$str() {
        return "HSEARCH000506: Invalid multi value: expected either a Collection or a String.";
    }
    @Override
    public final SearchException invalidMultiPropertyValue() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiPropertyValue$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotAddMultiplePredicatesToNestedPredicate$str() {
        return "HSEARCH000509: Cannot add multiple predicates to a nested predicate; use an explicit boolean predicate instead.";
    }
    @Override
    public final SearchException cannotAddMultiplePredicatesToNestedPredicate() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotAddMultiplePredicatesToNestedPredicate$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String matchPredicateCannotMatchNullValue$str() {
        return "HSEARCH000511: Invalid value: the value to match in match predicates must be non-null.";
    }
    @Override
    public final SearchException matchPredicateCannotMatchNullValue(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), matchPredicateCannotMatchNullValue$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rangePredicateCannotMatchNullValue$str() {
        return "HSEARCH000512: Invalid value: at least one bound in range predicates must be non-null.";
    }
    @Override
    public final SearchException rangePredicateCannotMatchNullValue(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangePredicateCannotMatchNullValue$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String relativeFieldNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000514: Field name '%1$s' is invalid: field names cannot be null or empty.";
    }
    @Override
    public final SearchException relativeFieldNameCannotBeNullOrEmpty(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeFieldNameCannotBeNullOrEmpty$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String relativeFieldNameCannotContainDot$str() {
        return "HSEARCH000515: Field name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.";
    }
    @Override
    public final SearchException relativeFieldNameCannotContainDot(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeFieldNameCannotContainDot$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str() {
        return "HSEARCH000516: Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.";
    }
    @Override
    public final IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(final GeoPoint firstPoint, final GeoPoint lastPoint) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str(), firstPoint, lastPoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String boostrapCollectedFailureLimitReached$str() {
        return "HSEARCH000519: Hibernate Search bootstrap failed; stopped collecting failures after '%2$s' failures. Failures:\n%1$s";
    }
    @Override
    public final SearchException boostrapCollectedFailureLimitReached(final String renderedFailures, final int failureCount) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), boostrapCollectedFailureLimitReached$str(), renderedFailures, failureCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bootstrapCollectedFailures$str() {
        return "HSEARCH000520: Hibernate Search bootstrap failed. Failures:\n%1$s";
    }
    @Override
    public final SearchException bootstrapCollectedFailures(final String renderedFailures) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), bootstrapCollectedFailures$str(), renderedFailures));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void newBootstrapCollectedFailure(final String context, final Throwable failure) {
        super.log.logf(FQCN, ERROR, failure, newBootstrapCollectedFailure$str(), context);
    }
    protected String newBootstrapCollectedFailure$str() {
        return "HSEARCH000521: Hibernate Search bootstrap encountered a non-fatal failure; continuing bootstrap for now to list all mapping problems, but the bootstrap process will ultimately be aborted.\nContext: %1$s\nFailure:";
    }
    @Override
    public final void unexpectedEmptyEventContext(final Throwable exceptionForStackTrace) {
        super.log.logf(FQCN, DEBUG, exceptionForStackTrace, unexpectedEmptyEventContext$str());
    }
    protected String unexpectedEmptyEventContext$str() {
        return "HSEARCH000522: Unexpected empty event context; there is a bug in Hibernate Search, please report it";
    }
    protected String cannotCallDslExtensionIfSupportedAfterOrElse$str() {
        return "HSEARCH000525: Cannot call ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.";
    }
    @Override
    public final SearchException cannotCallDslExtensionIfSupportedAfterOrElse() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCallDslExtensionIfSupportedAfterOrElse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String dslExtensionNoMatch$str() {
        return "HSEARCH000526: None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).";
    }
    @Override
    public final SearchException dslExtensionNoMatch(final List<?> attemptedExtensions) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), dslExtensionNoMatch$str(), attemptedExtensions));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInstantiateComponent$str() {
        return "HSEARCH000527: Unable to instantiate %1$s, class '%2$s': %3$s";
    }
    @Override
    public final SearchException unableToInstantiateComponent(final String componentDescription, final Class<?> classToLoad, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInstantiateComponent$str(), componentDescription, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityManagerLoadingError$str() {
        return "HSEARCH000528: %2$s defined for component %1$s could not be instantiated because of a security manager error";
    }
    @Override
    public final SearchException securityManagerLoadingError(final String componentDescription, final Class<?> classToLoad, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), securityManagerLoadingError$str(), componentDescription, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindComponentImplementation$str() {
        return "HSEARCH000529: Unable to find %1$s implementation class: %2$s";
    }
    @Override
    public final SearchException unableToFindComponentImplementation(final String componentDescription, final String classNameToLoad, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToFindComponentImplementation$str(), componentDescription, classNameToLoad), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadTheClass$str() {
        return "HSEARCH000530: Unable to load class [%1$s]";
    }
    @Override
    public final ClassLoadingException unableToLoadTheClass(final String className, final Throwable cause) {
        final ClassLoadingException result = new ClassLoadingException(String.format(getLoggingLocale(), unableToLoadTheClass$str(), className), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noBackendRegistered$str() {
        return "HSEARCH000533: No backend registered for backend name: '%1$s'.";
    }
    @Override
    public final SearchException noBackendRegistered(final String backendName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noBackendRegistered$str(), backendName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noIndexManagerRegistered$str() {
        return "HSEARCH000534: No index manager registered for index manager name: '%1$s'.";
    }
    @Override
    public final SearchException noIndexManagerRegistered(final String indexManagerName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noIndexManagerRegistered$str(), indexManagerName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInstantiateClass$str() {
        return "HSEARCH000540: Unable to instantiate class '%1$s': %2$s.";
    }
    @Override
    public final SearchException unableToInstantiateClass(final Class<?> classToLoad, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInstantiateClass$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interfaceImplementedExpected$str() {
        return "HSEARCH000541: Wrong configuration of %1$s: class %2$s does not implement interface %3$s.";
    }
    @Override
    public final SearchException interfaceImplementedExpected(final String component, final Class<?> classToLoad, final Class<?> superType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), interfaceImplementedExpected$str(), component, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), new org.hibernate.search.util.common.logging.impl.ClassFormatter(superType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String subtypeExpected$str() {
        return "HSEARCH000542: Wrong configuration of %1$s: class %2$s is not a subtype of %3$s.";
    }
    @Override
    public final SearchException subtypeExpected(final String component, final Class<?> classToLoad, final Class<?> superType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), subtypeExpected$str(), component, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), new org.hibernate.search.util.common.logging.impl.ClassFormatter(superType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String implementationRequired$str() {
        return "HSEARCH000543: %2$s defined for component %1$s is an interface: implementation required.";
    }
    @Override
    public final SearchException implementationRequired(final String component, final Class<?> classToLoad) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), implementationRequired$str(), component, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingConstructor$str() {
        return "HSEARCH000544: %2$s defined for component %1$s is missing an appropriate constructor: expected a public constructor with a single parameter of type Map.";
    }
    @Override
    public final SearchException missingConstructor(final String component, final Class<?> classToLoad) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingConstructor$str(), component, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAssignableImplementation$str() {
        return "HSEARCH000545: Unable to load class for %1$s. Configured implementation %2$s  is not assignable to type %3$s.";
    }
    @Override
    public final SearchException notAssignableImplementation(final String component, final String classToLoad, final Class<?> superType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notAssignableImplementation$str(), component, classToLoad, new org.hibernate.search.util.common.logging.impl.ClassFormatter(superType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexedEmbeddedCyclicRecursion$str() {
        return "HSEARCH000546: Found an infinite IndexedEmbedded recursion involving path '%1$s' on type '%2$s'.";
    }
    @Override
    public final SearchException indexedEmbeddedCyclicRecursion(final String cyclicRecursionPath, final MappableTypeModel parentTypeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexedEmbeddedCyclicRecursion$str(), cyclicRecursionPath, new org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter(parentTypeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBeanReferencePropertyValue$str() {
        return "HSEARCH000547: Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s";
    }
    @Override
    public final SearchException invalidBeanReferencePropertyValue(final Class<?> expectedType, final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBeanReferencePropertyValue$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedType), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBeanType$str() {
        return "HSEARCH000548: Invalid bean type: type '%2$s' is not assignable to '%1$s'.";
    }
    @Override
    public final SearchException invalidBeanType(final Class<?> expectedSuperType, final Class<?> actualType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBeanType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedSuperType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backendTypeCannotBeNullOrEmpty$str() {
        return "HSEARCH000549: Missing backend type for backend '%1$s'. Set the property '%2$s' to a supported value.";
    }
    @Override
    public final SearchException backendTypeCannotBeNullOrEmpty(final String backendName, final String key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendTypeCannotBeNullOrEmpty$str(), backendName, key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String defaultBackendNameNotSet$str() {
        return "HSEARCH000550: The name of the default backend is not set. Set it through the configuration property '%1$s', or set the backend name explicitly for each indexed type in your mapping.";
    }
    @Override
    public final SearchException defaultBackendNameNotSet(final String defaultKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), defaultBackendNameNotSet$str(), defaultKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String perFieldBoostWithConstantScore$str() {
        return "HSEARCH000551: It is not possible to use per-field boosts together with withConstantScore option";
    }
    @Override
    public final SearchException perFieldBoostWithConstantScore() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), perFieldBoostWithConstantScore$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String phrasePredicateCannotMatchNullPhrase$str() {
        return "HSEARCH000552: Invalid phrase: the phrase to match in phrase predicates must be non-null.";
    }
    @Override
    public final SearchException phrasePredicateCannotMatchNullPhrase(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), phrasePredicateCannotMatchNullPhrase$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPhrasePredicateSlop$str() {
        return "HSEARCH000553: Invalid slop: %1$d. The slop must be positive or zero.";
    }
    @Override
    public final SearchException invalidPhrasePredicateSlop(final int slop) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPhrasePredicateSlop$str(), slop));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFuzzyMaximumEditDistance$str() {
        return "HSEARCH000554: Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.";
    }
    @Override
    public final SearchException invalidFuzzyMaximumEditDistance(final int maximumEditDistance) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFuzzyMaximumEditDistance$str(), maximumEditDistance));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidExactPrefixLength$str() {
        return "HSEARCH000555: Invalid exact prefix length: %1$d. The value must be positive or zero.";
    }
    @Override
    public final SearchException invalidExactPrefixLength(final int exactPrefixLength) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidExactPrefixLength$str(), exactPrefixLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wildcardPredicateCannotMatchNullPattern$str() {
        return "HSEARCH000556: Invalid pattern: the pattern to match in wildcard predicates must be non-null.";
    }
    @Override
    public final SearchException wildcardPredicateCannotMatchNullPattern(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), wildcardPredicateCannotMatchNullPattern$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseTemporal$str() {
        return "HSEARCH000557: '%1$s' instance cannot be parsed from value: '%2$s', using the expected formatter: '%3$s'.";
    }
    @Override
    public final SearchException unableToParseTemporal(final Class<? extends java.time.temporal.TemporalAccessor> type, final String value, final DateTimeFormatter formatter, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToParseTemporal$str(), new org.hibernate.search.engine.logging.spi.SimpleNameClassFormatter(type), value, formatter), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNumberPropertyValue$str() {
        return "HSEARCH000558: Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s";
    }
    @Override
    public final SearchException invalidNumberPropertyValue(final Class<? extends Number> type, final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNumberPropertyValue$str(), new org.hibernate.search.engine.logging.spi.SimpleNameClassFormatter(type), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidStringForType$str() {
        return "HSEARCH000559: Invalid '%1$s' value for type '%2$s'.";
    }
    @Override
    public final SearchException invalidStringForType(final String value, final Class<?> type, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidStringForType$str(), value, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidStringForEnum$str() {
        return "HSEARCH000560: Invalid '%1$s' value for enum '%2$s'.";
    }
    @Override
    public final SearchException invalidStringForEnum(final String value, final Class<? extends Enum> enumType, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidStringForEnum$str(), value, new org.hibernate.search.util.common.logging.impl.ClassFormatter(enumType)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonSingleHit$str() {
        return "HSEARCH000561: Multiple hits when a single hit was expected: got %1$s hits.";
    }
    @Override
    public final SearchException nonSingleHit(final long totalHitCount) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonSingleHit$str(), totalHitCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String threadInterruptedWhileSubmittingWorkset$str() {
        return "HSEARCH000562: The thread was interrupted while a workset was being submitted to '%1$s'. The workset has been discarded.";
    }
    @Override
    public final SearchException threadInterruptedWhileSubmittingWorkset(final String orchestratorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), threadInterruptedWhileSubmittingWorkset$str(), orchestratorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String submittedWorkToStoppedOrchestrator$str() {
        return "HSEARCH000563: A workset was submitted to '%1$s', but this orchestrator was stopped. The workset has been discarded.";
    }
    @Override
    public final SearchException submittedWorkToStoppedOrchestrator(final String orchestratorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), submittedWorkToStoppedOrchestrator$str(), orchestratorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseGeoPoint$str() {
        return "HSEARCH000564: Unable to parse the provided geo-point value: '%1$s'. The expected format is latitude, longitude.";
    }
    @Override
    public final SearchException unableToParseGeoPoint(final String value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToParseGeoPoint$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAggregationKey$str() {
        return "HSEARCH000565: Unknown aggregation key '%1$s'. This key was not used when building the search query.";
    }
    @Override
    public final SearchException unknownAggregationKey(final AggregationKey<?> key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownAggregationKey$str(), key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidConfigurationPropertyCheckingStrategyName$str() {
        return "HSEARCH000566: Invalid configuration property checking strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidConfigurationPropertyCheckingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidConfigurationPropertyCheckingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void configurationPropertyTrackingDisabled() {
        super.log.logf(FQCN, INFO, null, configurationPropertyTrackingDisabled$str());
    }
    protected String configurationPropertyTrackingDisabled$str() {
        return "HSEARCH000567: Configuration property tracking is disabled; unused properties will not be logged.";
    }
    @Override
    public final void configurationPropertyTrackingUnusedProperties(final Set<String> propertyKeys, final String disableWarningKey, final String disableWarningValue) {
        super.log.logf(FQCN, WARN, null, configurationPropertyTrackingUnusedProperties$str(), propertyKeys, disableWarningKey, disableWarningValue);
    }
    protected String configurationPropertyTrackingUnusedProperties$str() {
        return "HSEARCH000568: Some properties in the Hibernate Search configuration were not used; there might be misspelled property keys in your configuration. Unused properties were: %1$s. To disable this warning, set the property '%2$s' to '%3$s'.";
    }
    @Override
    public final void failureInFailureHandler(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failureInFailureHandler$str());
    }
    protected String failureInFailureHandler$str() {
        return "HSEARCH000569: The background failure handler threw an exception while handling a previous failure. The failure may not have been reported.";
    }
}
