/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter;
import org.hibernate.search.engine.logging.spi.SimpleNameClassFormatter;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=0, max=9999)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_1 = 0;
    public static final int ID_OFFSET_2 = 500;

    @Message(id=242, value="Hibernate Search failed to initialize component '%1$s' as class '%2$s' doesn't have a public no-arguments constructor")
    public SearchException noPublicNoArgConstructor(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=334, value="Invalid simple query string: the string must be non-null. Null value was passed to simple query string predicate on fields %1$s.")
    public SearchException simpleQueryStringCannotBeNull(Collection<String> var1);

    @Message(id=501, value="Unable to convert configuration property '%1$s' with value '%2$s': %3$s")
    public SearchException unableToConvertConfigurationProperty(String var1, Object var2, String var3, @Cause Exception var4);

    @Message(id=502, value="Invalid value: expected either an instance of '%1$s' or a String that can be parsed. %2$s")
    public SearchException invalidPropertyValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=503, value="Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s")
    public SearchException invalidBooleanPropertyValue(String var1, @Cause Exception var2);

    @Message(id=504, value="Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s")
    public SearchException invalidIntegerPropertyValue(String var1, @Cause Exception var2);

    @Message(id=505, value="Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s")
    public SearchException invalidLongPropertyValue(String var1, @Cause Exception var2);

    @Message(id=506, value="Invalid multi value: expected either a Collection or a String.")
    public SearchException invalidMultiPropertyValue();

    @Message(id=509, value="Cannot add multiple predicates to a nested predicate; use an explicit boolean predicate instead.")
    public SearchException cannotAddMultiplePredicatesToNestedPredicate();

    @Message(id=511, value="Invalid value: the value to match in match predicates must be non-null.")
    public SearchException matchPredicateCannotMatchNullValue(@Param EventContext var1);

    @Message(id=512, value="Invalid value: at least one bound in range predicates must be non-null.")
    public SearchException rangePredicateCannotMatchNullValue(@Param EventContext var1);

    @Message(id=514, value="Field name '%1$s' is invalid: field names cannot be null or empty.")
    public SearchException relativeFieldNameCannotBeNullOrEmpty(String var1, @Param EventContext var2);

    @Message(id=515, value="Field name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.")
    public SearchException relativeFieldNameCannotContainDot(String var1, @Param EventContext var2);

    @Message(id=516, value="Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.")
    public IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(GeoPoint var1, GeoPoint var2);

    @Message(id=519, value="Hibernate Search bootstrap failed; stopped collecting failures after '%2$s' failures. Failures:\n%1$s")
    public SearchException boostrapCollectedFailureLimitReached(String var1, int var2);

    @Message(id=520, value="Hibernate Search bootstrap failed. Failures:\n%1$s")
    public SearchException bootstrapCollectedFailures(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=521, value="Hibernate Search bootstrap encountered a non-fatal failure; continuing bootstrap for now to list all mapping problems, but the bootstrap process will ultimately be aborted.\nContext: %1$s\nFailure:")
    public void newBootstrapCollectedFailure(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=522, value="Unexpected empty event context; there is a bug in Hibernate Search, please report it")
    public void unexpectedEmptyEventContext(@Cause Throwable var1);

    @Message(id=525, value="Cannot call ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.")
    public SearchException cannotCallDslExtensionIfSupportedAfterOrElse();

    @Message(id=526, value="None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).")
    public SearchException dslExtensionNoMatch(List<?> var1);

    @Message(id=527, value="Unable to instantiate %1$s, class '%2$s': %3$s")
    public SearchException unableToInstantiateComponent(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, String var3, @Cause Exception var4);

    @Message(id=528, value="%2$s defined for component %1$s could not be instantiated because of a security manager error")
    public SearchException securityManagerLoadingError(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Cause Exception var3);

    @Message(id=529, value="Unable to find %1$s implementation class: %2$s")
    public SearchException unableToFindComponentImplementation(String var1, String var2, @Cause Exception var3);

    @Message(id=530, value="Unable to load class [%1$s]")
    public ClassLoadingException unableToLoadTheClass(String var1, @Cause Throwable var2);

    @Message(id=533, value="No backend registered for backend name: '%1$s'.")
    public SearchException noBackendRegistered(String var1);

    @Message(id=534, value="No index manager registered for index manager name: '%1$s'.")
    public SearchException noIndexManagerRegistered(String var1);

    @Message(id=540, value="Unable to instantiate class '%1$s': %2$s.")
    public SearchException unableToInstantiateClass(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=541, value="Wrong configuration of %1$s: class %2$s does not implement interface %3$s.")
    public SearchException interfaceImplementedExpected(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=542, value="Wrong configuration of %1$s: class %2$s is not a subtype of %3$s.")
    public SearchException subtypeExpected(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=543, value="%2$s defined for component %1$s is an interface: implementation required.")
    public SearchException implementationRequired(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=544, value="%2$s defined for component %1$s is missing an appropriate constructor: expected a public constructor with a single parameter of type Map.")
    public SearchException missingConstructor(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=545, value="Unable to load class for %1$s. Configured implementation %2$s  is not assignable to type %3$s.")
    public SearchException notAssignableImplementation(String var1, String var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=546, value="Found an infinite IndexedEmbedded recursion involving path '%1$s' on type '%2$s'.")
    public SearchException indexedEmbeddedCyclicRecursion(String var1, @FormatWith(value=MappableTypeModelFormatter.class) MappableTypeModel var2);

    @Message(id=547, value="Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s")
    public SearchException invalidBeanReferencePropertyValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=548, value="Invalid bean type: type '%2$s' is not assignable to '%1$s'.")
    public SearchException invalidBeanType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=549, value="Missing backend type for backend '%1$s'. Set the property '%2$s' to a supported value.")
    public SearchException backendTypeCannotBeNullOrEmpty(String var1, String var2);

    @Message(id=550, value="The name of the default backend is not set. Set it through the configuration property '%1$s', or set the backend name explicitly for each indexed type in your mapping.")
    public SearchException defaultBackendNameNotSet(String var1);

    @Message(id=551, value="It is not possible to use per-field boosts together with withConstantScore option")
    public SearchException perFieldBoostWithConstantScore();

    @Message(id=552, value="Invalid phrase: the phrase to match in phrase predicates must be non-null.")
    public SearchException phrasePredicateCannotMatchNullPhrase(@Param EventContext var1);

    @Message(id=553, value="Invalid slop: %1$d. The slop must be positive or zero.")
    public SearchException invalidPhrasePredicateSlop(int var1);

    @Message(id=554, value="Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.")
    public SearchException invalidFuzzyMaximumEditDistance(int var1);

    @Message(id=555, value="Invalid exact prefix length: %1$d. The value must be positive or zero.")
    public SearchException invalidExactPrefixLength(int var1);

    @Message(id=556, value="Invalid pattern: the pattern to match in wildcard predicates must be non-null.")
    public SearchException wildcardPredicateCannotMatchNullPattern(@Param EventContext var1);

    @Message(id=557, value="'%1$s' instance cannot be parsed from value: '%2$s', using the expected formatter: '%3$s'.")
    public SearchException unableToParseTemporal(@FormatWith(value=SimpleNameClassFormatter.class) Class<? extends TemporalAccessor> var1, String var2, DateTimeFormatter var3, @Cause Exception var4);

    @Message(id=558, value="Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s")
    public SearchException invalidNumberPropertyValue(@FormatWith(value=SimpleNameClassFormatter.class) Class<? extends Number> var1, String var2, @Cause Exception var3);

    @Message(id=559, value="Invalid '%1$s' value for type '%2$s'.")
    public SearchException invalidStringForType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Cause Exception var3);

    @Message(id=560, value="Invalid '%1$s' value for enum '%2$s'.")
    public SearchException invalidStringForEnum(String var1, @FormatWith(value=ClassFormatter.class) Class<? extends Enum> var2, @Cause Exception var3);

    @Message(id=561, value="Multiple hits when a single hit was expected: got %1$s hits.")
    public SearchException nonSingleHit(long var1);

    @Message(id=562, value="The thread was interrupted while a workset was being submitted to '%1$s'. The workset has been discarded.")
    public SearchException threadInterruptedWhileSubmittingWorkset(String var1);

    @Message(id=563, value="A workset was submitted to '%1$s', but this orchestrator was stopped. The workset has been discarded.")
    public SearchException submittedWorkToStoppedOrchestrator(String var1);

    @Message(id=564, value="Unable to parse the provided geo-point value: '%1$s'. The expected format is latitude, longitude.")
    public SearchException unableToParseGeoPoint(String var1);

    @Message(id=565, value="Unknown aggregation key '%1$s'. This key was not used when building the search query.")
    public SearchException unknownAggregationKey(AggregationKey<?> var1);

    @Message(id=566, value="Invalid configuration property checking strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidConfigurationPropertyCheckingStrategyName(String var1, List<String> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=567, value="Configuration property tracking is disabled; unused properties will not be logged.")
    public void configurationPropertyTrackingDisabled();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=568, value="Some properties in the Hibernate Search configuration were not used; there might be misspelled property keys in your configuration. Unused properties were: %1$s. To disable this warning, set the property '%2$s' to '%3$s'.")
    public void configurationPropertyTrackingUnusedProperties(Set<String> var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=569, value="The background failure handler threw an exception while handling a previous failure. The failure may not have been reported.")
    public void failureInFailureHandler(@Cause Throwable var1);
}

