/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.impl.BackendPartialBuildState;
import org.hibernate.search.engine.common.impl.IndexManagerPartialBuildState;
import org.hibernate.search.engine.common.impl.MappingFinalizationContextImpl;
import org.hibernate.search.engine.common.impl.SearchIntegrationImpl;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationFinalizer;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingFinalizer;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.impl.RootFailureCollector;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;

class SearchIntegrationPartialBuildStateImpl
implements SearchIntegrationPartialBuildState {
    private static final int FAILURE_LIMIT = 100;
    private final BeanProvider beanProvider;
    private final BeanResolver beanResolver;
    private final BeanHolder<? extends FailureHandler> failureHandlerHolder;
    private final BeanHolder<? extends ThreadProvider> threadProviderHolder;
    private final Map<MappingKey<?, ?>, MappingPartialBuildState> partiallyBuiltMappings;
    private final List<MappingImplementor<?>> fullyBuiltMappings = new ArrayList();
    private final Map<String, BackendPartialBuildState> partiallyBuiltBackends;
    private final ConfigurationPropertyChecker partialConfigurationPropertyChecker;
    private final Map<String, BackendImplementor<?>> fullyBuiltBackends = new LinkedHashMap();
    private final Map<String, IndexManagerPartialBuildState> partiallyBuiltIndexManagers;
    private final Map<String, IndexManagerImplementor<?>> fullyBuiltIndexManagers = new LinkedHashMap();

    SearchIntegrationPartialBuildStateImpl(BeanProvider beanProvider, BeanResolver beanResolver, BeanHolder<? extends FailureHandler> failureHandlerHolder, BeanHolder<? extends ThreadProvider> threadProviderHolder, Map<MappingKey<?, ?>, MappingPartialBuildState> partiallyBuiltMappings, Map<String, BackendPartialBuildState> partiallyBuiltBackends, Map<String, IndexManagerPartialBuildState> partiallyBuiltIndexManagers, ConfigurationPropertyChecker partialConfigurationPropertyChecker) {
        this.beanProvider = beanProvider;
        this.beanResolver = beanResolver;
        this.failureHandlerHolder = failureHandlerHolder;
        this.threadProviderHolder = threadProviderHolder;
        this.partiallyBuiltMappings = partiallyBuiltMappings;
        this.partiallyBuiltBackends = partiallyBuiltBackends;
        this.partiallyBuiltIndexManagers = partiallyBuiltIndexManagers;
        this.partialConfigurationPropertyChecker = partialConfigurationPropertyChecker;
    }

    @Override
    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(MappingPartialBuildState::closeOnFailure, this.partiallyBuiltMappings.values());
            closer.pushAll(MappingImplementor::close, this.fullyBuiltMappings);
            closer.pushAll(IndexManagerPartialBuildState::closeOnFailure, this.partiallyBuiltIndexManagers.values());
            closer.pushAll(IndexManagerImplementor::stop, this.fullyBuiltIndexManagers.values());
            closer.pushAll(BackendPartialBuildState::closeOnFailure, this.partiallyBuiltBackends.values());
            closer.pushAll(BackendImplementor::stop, this.fullyBuiltBackends.values());
            closer.pushAll(BeanHolder::close, (Object[])new BeanHolder[]{this.threadProviderHolder});
            closer.pushAll(BeanHolder::close, (Object[])new BeanHolder[]{this.failureHandlerHolder});
            closer.pushAll(BeanProvider::close, (Object[])new BeanProvider[]{this.beanProvider});
        }
    }

    @Override
    public SearchIntegrationFinalizer finalizer(ConfigurationPropertySource propertySource, ConfigurationPropertyChecker configurationPropertyChecker) {
        return new SearchIntegrationFinalizerImpl(propertySource.withMask("hibernate.search"), configurationPropertyChecker);
    }

    private class SearchIntegrationFinalizerImpl
    implements SearchIntegrationFinalizer {
        private final ConfigurationPropertySource propertySource;
        private final ConfigurationPropertyChecker propertyChecker;

        private SearchIntegrationFinalizerImpl(ConfigurationPropertySource propertySource, ConfigurationPropertyChecker propertyChecker) {
            this.propertySource = propertySource;
            this.propertyChecker = propertyChecker;
        }

        @Override
        public <PBM, M> M finalizeMapping(MappingKey<PBM, M> mappingKey, MappingFinalizer<PBM, M> finalizer) {
            Object partiallyBuiltMapping = SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltMappings.get(mappingKey);
            if (partiallyBuiltMapping == null) {
                throw new AssertionFailure("Some partially built mapping could not be found during bootstrap; there is probably a bug in Hibernate Search. Key: " + mappingKey);
            }
            MappingFinalizationContextImpl mappingFinalizationContext = new MappingFinalizationContextImpl(this.propertySource);
            MappingImplementor<M> mapping = finalizer.finalizeMapping(mappingFinalizationContext, partiallyBuiltMapping);
            SearchIntegrationPartialBuildStateImpl.this.fullyBuiltMappings.add(mapping);
            SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltMappings.remove(mappingKey);
            return mapping.toConcreteType();
        }

        @Override
        public SearchIntegration finalizeIntegration() {
            if (!SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltMappings.isEmpty()) {
                throw new AssertionFailure("Some mappings were not fully built; there is probably a bug in Hibernate Search. Partially built mappings: " + SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltMappings);
            }
            RootFailureCollector failureCollector = new RootFailureCollector(100);
            for (Map.Entry entry : SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltBackends.entrySet()) {
                SearchIntegrationPartialBuildStateImpl.this.fullyBuiltBackends.put(entry.getKey(), ((BackendPartialBuildState)entry.getValue()).finalizeBuild(failureCollector, SearchIntegrationPartialBuildStateImpl.this.beanResolver, this.propertySource));
            }
            failureCollector.checkNoFailure();
            CompletableFuture[] indexManagerFutures = new CompletableFuture[SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltIndexManagers.size()];
            int indexManagerIndex = 0;
            for (IndexManagerPartialBuildState indexManagerPartialBuildState : SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltIndexManagers.values()) {
                indexManagerFutures[indexManagerIndex] = indexManagerPartialBuildState.finalizeBuild(failureCollector, SearchIntegrationPartialBuildStateImpl.this.beanResolver, this.propertySource);
                ++indexManagerIndex;
            }
            Futures.unwrappedExceptionJoin(CompletableFuture.allOf(indexManagerFutures));
            failureCollector.checkNoFailure();
            for (Map.Entry entry : SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltIndexManagers.entrySet()) {
                SearchIntegrationPartialBuildStateImpl.this.fullyBuiltIndexManagers.put(entry.getKey(), ((IndexManagerPartialBuildState)entry.getValue()).getIndexManager());
            }
            this.propertyChecker.afterBoot(SearchIntegrationPartialBuildStateImpl.this.partialConfigurationPropertyChecker, this.propertySource);
            return new SearchIntegrationImpl(SearchIntegrationPartialBuildStateImpl.this.beanProvider, SearchIntegrationPartialBuildStateImpl.this.failureHandlerHolder, SearchIntegrationPartialBuildStateImpl.this.threadProviderHolder, SearchIntegrationPartialBuildStateImpl.this.fullyBuiltMappings, SearchIntegrationPartialBuildStateImpl.this.fullyBuiltBackends, SearchIntegrationPartialBuildStateImpl.this.fullyBuiltIndexManagers);
        }
    }
}

