/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.work.execution.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.util.common.AssertionFailure;

public final class IndexIndexingPlanExecutionReport {
    private final Throwable throwable;
    private final List<DocumentReference> failingDocuments;

    public static Builder builder() {
        return new Builder();
    }

    public static CompletableFuture<IndexIndexingPlanExecutionReport> allOf(List<CompletableFuture<IndexIndexingPlanExecutionReport>> reportFutures) {
        if (reportFutures.size() == 1) {
            return reportFutures.get(0);
        }
        CompletionStage<Builder> reportBuilderFuture = CompletableFuture.completedFuture(IndexIndexingPlanExecutionReport.builder());
        for (CompletableFuture<IndexIndexingPlanExecutionReport> future : reportFutures) {
            reportBuilderFuture = reportBuilderFuture.thenCombine(future, Builder::add);
        }
        return reportBuilderFuture.thenApply(Builder::build);
    }

    private IndexIndexingPlanExecutionReport(Builder builder) {
        this.failingDocuments = builder.failingDocuments == null ? Collections.emptyList() : Collections.unmodifiableList(builder.failingDocuments);
        this.throwable = builder.throwable == null && !this.failingDocuments.isEmpty() ? new AssertionFailure("Unknown throwable: missing throwable when reporting the failure. There is probably a bug in Hibernate Search, please report it.") : builder.throwable;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public List<DocumentReference> getFailingDocuments() {
        return this.failingDocuments;
    }

    public static final class Builder {
        private Throwable throwable;
        private List<DocumentReference> failingDocuments;

        private Builder() {
        }

        public Builder add(IndexIndexingPlanExecutionReport report) {
            report.getThrowable().ifPresent(this::throwable);
            for (DocumentReference failingDocument : report.getFailingDocuments()) {
                this.failingDocument(failingDocument);
            }
            return this;
        }

        public Builder throwable(Throwable throwable) {
            if (this.throwable == null) {
                this.throwable = throwable;
            } else if (this.throwable != throwable) {
                this.throwable.addSuppressed(throwable);
            }
            return this;
        }

        public Builder failingDocument(DocumentReference reference) {
            if (this.failingDocuments == null) {
                this.failingDocuments = new ArrayList<DocumentReference>();
            }
            this.failingDocuments.add(reference);
            return this;
        }

        public IndexIndexingPlanExecutionReport build() {
            return new IndexIndexingPlanExecutionReport(this);
        }
    }
}

