/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting.spi;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.ToStringStyle;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.EventContextElement;
import org.hibernate.search.util.common.reporting.impl.CommonEventContextMessages;

public final class RootFailureCollector
implements FailureCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final int FAILURE_LIMIT = 100;
    private final String process;
    private final NonRootFailureCollector delegate;
    private final AtomicInteger failureCount = new AtomicInteger();

    public RootFailureCollector(String process) {
        this.process = process;
        this.delegate = new NonRootFailureCollector(this);
    }

    public void checkNoFailure() {
        if (this.failureCount.get() > 0) {
            String renderedFailures = this.renderFailures();
            throw log.collectedFailures(this.process, renderedFailures);
        }
    }

    private String renderFailures() {
        ToStringStyle style = ToStringStyle.multilineIndentStructure((String)EngineEventContextMessages.INSTANCE.failureReportContextFailuresSeparator(), (String)EngineEventContextMessages.INSTANCE.failureReportContextIndent(), (String)EngineEventContextMessages.INSTANCE.failureReportFailuresBulletPoint(), (String)EngineEventContextMessages.INSTANCE.failureReportFailuresNoBulletPoint());
        ToStringTreeBuilder builder = new ToStringTreeBuilder(style);
        if (this.delegate != null) {
            this.delegate.appendFailuresTo(builder);
        }
        return builder.toString();
    }

    @Override
    public ContextualFailureCollector withContext(EventContext context) {
        return this.delegate.withContext(context);
    }

    @Override
    public ContextualFailureCollector withContext(EventContextElement contextElement) {
        return this.delegate.withContext(contextElement);
    }

    private void onAddFailure() {
        int theFailureCount = this.failureCount.incrementAndGet();
        if (theFailureCount >= 100) {
            String renderedFailures = this.renderFailures();
            throw log.collectedFailureLimitReached(this.process, renderedFailures, theFailureCount);
        }
    }

    private static class ContextualFailureCollectorImpl
    extends NonRootFailureCollector
    implements ContextualFailureCollector {
        private final NonRootFailureCollector parent;
        private final EventContextElement context;
        private final List<String> failureMessages = new ArrayList<String>();

        private ContextualFailureCollectorImpl(NonRootFailureCollector parent, EventContextElement context) {
            super(parent);
            this.parent = parent;
            this.context = context;
        }

        @Override
        public synchronized boolean hasFailure() {
            if (!this.failureMessages.isEmpty()) {
                return true;
            }
            for (ContextualFailureCollectorImpl child : this.children().values()) {
                if (!child.hasFailure()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void add(Throwable t) {
            if (t instanceof SearchException) {
                SearchException e = (SearchException)t;
                ContextualFailureCollectorImpl failureCollector = this;
                EventContext eventContext = e.context();
                if (eventContext != null) {
                    failureCollector = failureCollector.withContext(e.context());
                }
                failureCollector.doAdd((Throwable)e, e.messageWithoutContext());
            } else {
                this.doAdd(t, t.getMessage());
            }
        }

        @Override
        public void add(String failureMessage) {
            this.doAdd(failureMessage);
        }

        @Override
        ContextualFailureCollectorImpl withDefaultContext() {
            return this;
        }

        @Override
        void appendContextTo(StringJoiner joiner) {
            this.parent.appendContextTo(joiner);
            joiner.add(this.context.render());
        }

        @Override
        synchronized void appendFailuresTo(ToStringTreeBuilder builder) {
            builder.startObject(this.context.render());
            if (!this.failureMessages.isEmpty()) {
                builder.startList(EngineEventContextMessages.INSTANCE.failureReportFailures());
                for (String failureMessage : this.failureMessages) {
                    builder.value((Object)failureMessage);
                }
                builder.endList();
            }
            this.appendChildrenFailuresTo(builder);
            builder.endObject();
        }

        private synchronized void doAdd(Throwable failure, String failureMessage) {
            StringJoiner contextJoiner = new StringJoiner(CommonEventContextMessages.INSTANCE.contextSeparator());
            this.appendContextTo(contextJoiner);
            log.newCollectedFailure(this.root.process, contextJoiner.toString(), failure);
            this.doAdd(failureMessage);
        }

        private synchronized void doAdd(String failureMessage) {
            this.failureMessages.add(failureMessage);
            this.root.onAddFailure();
        }
    }

    private static class NonRootFailureCollector
    implements FailureCollector {
        protected final RootFailureCollector root;
        private final Map<EventContextElement, ContextualFailureCollectorImpl> children = new LinkedHashMap<EventContextElement, ContextualFailureCollectorImpl>();

        private NonRootFailureCollector(RootFailureCollector root) {
            this.root = root;
        }

        protected NonRootFailureCollector(NonRootFailureCollector parent) {
            this.root = parent.root;
        }

        @Override
        public synchronized ContextualFailureCollectorImpl withContext(EventContext context) {
            List elements = context.elements();
            if (elements.isEmpty()) {
                log.unexpectedEmptyEventContext(new IllegalStateException("Exception for stack trace"));
                return this.withDefaultContext();
            }
            NonRootFailureCollector failureCollector = this;
            for (EventContextElement contextElement : elements) {
                failureCollector = failureCollector.withContext(contextElement);
            }
            return (ContextualFailureCollectorImpl)failureCollector;
        }

        @Override
        public synchronized ContextualFailureCollectorImpl withContext(EventContextElement contextElement) {
            return this.children.computeIfAbsent(contextElement, element -> new ContextualFailureCollectorImpl(this, (EventContextElement)element));
        }

        ContextualFailureCollectorImpl withDefaultContext() {
            return this.withContext(EventContexts.defaultContext());
        }

        void appendContextTo(StringJoiner joiner) {
        }

        void appendFailuresTo(ToStringTreeBuilder builder) {
            builder.startObject();
            this.appendChildrenFailuresTo(builder);
            builder.endObject();
        }

        final synchronized void appendChildrenFailuresTo(ToStringTreeBuilder builder) {
            for (ContextualFailureCollectorImpl child : this.children.values()) {
                if (!child.hasFailure()) continue;
                child.appendFailuresTo(builder);
            }
        }

        final Map<EventContextElement, ContextualFailureCollectorImpl> children() {
            return this.children;
        }
    }
}

