/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.spi;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoaderHelper;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;

public final class ReflectionBeanProvider
implements BeanProvider {
    private final ClassResolver classResolver;

    public static ReflectionBeanProvider create(ClassResolver classResolver) {
        return new ReflectionBeanProvider(classResolver);
    }

    private ReflectionBeanProvider(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public void close() {
    }

    @Override
    public <T> BeanHolder<T> forType(Class<T> typeReference) {
        return BeanHolder.of(this.forTypeNoClosingNecessary(typeReference));
    }

    public <T> T forTypeNoClosingNecessary(Class<T> typeReference) {
        return ClassLoaderHelper.untypedInstanceFromClass(typeReference, typeReference.getName());
    }

    @Override
    public <T> BeanHolder<T> forTypeAndName(Class<T> typeReference, String implementationFullyQualifiedClassName) {
        return BeanHolder.of(this.forTypeAndNameNoClosingNecessary(typeReference, implementationFullyQualifiedClassName));
    }

    public <T> T forTypeAndNameNoClosingNecessary(Class<T> typeReference, String implementationFullyQualifiedClassName) {
        Class<T> implementationClass = ClassLoaderHelper.classForName(typeReference, implementationFullyQualifiedClassName, typeReference.getName(), this.classResolver);
        return ClassLoaderHelper.untypedInstanceFromClass(implementationClass, implementationFullyQualifiedClassName);
    }
}

