/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.spi;

import java.util.Optional;
import java.util.function.Consumer;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;

public final class ConsumedPropertyTrackingConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource delegate;
    private final Consumer<String> tracker;

    public ConsumedPropertyTrackingConfigurationPropertySource(ConfigurationPropertySource delegate, Consumer<String> tracker) {
        this.delegate = delegate;
        this.tracker = tracker;
    }

    @Override
    public Optional<?> get(String key) {
        Optional<String> resolved = this.resolve(key);
        if (resolved.isPresent()) {
            this.tracker.accept(resolved.get());
        }
        return this.delegate.get(key);
    }

    @Override
    public Optional<String> resolve(String key) {
        return this.delegate.resolve(key);
    }
}

