/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.cfg.spi.AllAwareConfigurationPropertySource;

public class MapConfigurationPropertySource
implements AllAwareConfigurationPropertySource {
    private final Map<String, ?> map;

    public MapConfigurationPropertySource(Map<String, ?> map) {
        this.map = map;
    }

    @Override
    public Optional<?> get(String key) {
        Object value = this.map.get(key);
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<String> resolve(String key) {
        return Optional.of(key);
    }

    @Override
    public Set<String> resolveAll(String prefix) {
        HashSet<String> prefixedPropertyKeys = new HashSet<String>();
        for (String key : this.map.keySet()) {
            String stringKey;
            if (!(key instanceof String) || !(stringKey = key).startsWith(prefix)) continue;
            prefixedPropertyKeys.add(stringKey);
        }
        return prefixedPropertyKeys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("map=").append(this.map).append("]");
        return sb.toString();
    }
}

