/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.dsl.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQueryOptionsStep;
import org.hibernate.search.engine.search.query.dsl.SearchQueryPredicateStep;
import org.hibernate.search.engine.search.query.dsl.impl.DefaultSearchQueryOptionsStep;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQueryHitTypeStep;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public final class DefaultSearchQueryHitTypeStep<R, E, C>
extends AbstractSearchQueryHitTypeStep<SearchQueryOptionsStep<?, E, ?, ?>, R, E, SearchProjectionFactory<R, E>, SearchPredicateFactory, C> {
    private final IndexScope<C> indexScope;
    private final BackendSessionContext sessionContext;
    private final LoadingContextBuilder<R, E> loadingContextBuilder;

    public DefaultSearchQueryHitTypeStep(IndexScope<C> indexScope, BackendSessionContext sessionContext, LoadingContextBuilder<R, E> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public SearchQueryPredicateStep<?, E, ?> asEntity() {
        SearchQueryBuilder<E, C> builder = this.indexScope.getSearchQueryBuilderFactory().asEntity(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryOptionsStep<E, C>(this.indexScope, builder);
    }

    @Override
    public SearchQueryPredicateStep<?, R, ?> asEntityReference() {
        SearchQueryBuilder<R, C> builder = this.indexScope.getSearchQueryBuilderFactory().asReference(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryOptionsStep<R, C>(this.indexScope, builder);
    }

    @Override
    public <P> SearchQueryPredicateStep<?, P, ?> asProjection(Function<? super SearchProjectionFactory<R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        SearchProjectionFactory factory = this.createDefaultProjectionFactory();
        SearchProjection<P> projection = projectionContributor.apply(factory).toProjection();
        return this.asProjection(projection);
    }

    @Override
    public <P> SearchQueryPredicateStep<?, P, ?> asProjection(SearchProjection<P> projection) {
        SearchQueryBuilder<P, C> builder = this.indexScope.getSearchQueryBuilderFactory().asProjection(this.sessionContext, this.loadingContextBuilder, projection);
        return new DefaultSearchQueryOptionsStep<P, C>(this.indexScope, builder);
    }

    @Override
    public SearchQueryPredicateStep<?, List<?>, ?> asProjections(SearchProjection<?> ... projections) {
        SearchQueryBuilder<List<R>, C> builder = this.indexScope.getSearchQueryBuilderFactory().asProjections(this.sessionContext, this.loadingContextBuilder, projections);
        return new DefaultSearchQueryOptionsStep<List<R>, C>(this.indexScope, builder);
    }

    @Override
    public SearchQueryOptionsStep<?, E, ?, ?> predicate(Function<? super SearchPredicateFactory, ? extends PredicateFinalStep> predicateContributor) {
        return this.asEntity().predicate(predicateContributor);
    }

    @Override
    public SearchQueryOptionsStep<?, E, ?, ?> predicate(SearchPredicate predicate) {
        return this.asEntity().predicate(predicate);
    }

    @Override
    protected IndexScope<C> getIndexScope() {
        return this.indexScope;
    }

    @Override
    protected BackendSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    protected LoadingContextBuilder<R, E> getLoadingContextBuilder() {
        return this.loadingContextBuilder;
    }
}

