/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.WildcardPredicateFieldSetContext;
import org.hibernate.search.engine.search.dsl.predicate.WildcardPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class WildcardPredicateFieldSetContextImpl<B>
implements WildcardPredicateFieldSetContext,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetContext<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<WildcardPredicateBuilder<B>> predicateBuilders = new ArrayList<WildcardPredicateBuilder<B>>();
    private Float fieldSetBoost;

    WildcardPredicateFieldSetContextImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.wildcard(absoluteFieldPath));
        }
    }

    @Override
    public WildcardPredicateFieldSetContext orFields(String ... absoluteFieldPaths) {
        return new WildcardPredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public WildcardPredicateFieldSetContext boostedTo(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public WildcardPredicateTerminalContext matching(String wildcard) {
        return ((CommonState)this.commonState).matching(wildcard);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (WildcardPredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, WildcardPredicateFieldSetContextImpl<B>>
    implements WildcardPredicateTerminalContext {
        CommonState(SearchPredicateBuilderFactory<?, B> factory) {
            super(factory);
        }

        private WildcardPredicateTerminalContext matching(String wildcardPattern) {
            if (wildcardPattern == null) {
                throw log.wildcardPredicateCannotMatchNullPattern(this.getEventContext());
            }
            for (WildcardPredicateFieldSetContextImpl fieldSetContext : this.getFieldSetContexts()) {
                for (WildcardPredicateBuilder predicateBuilder : fieldSetContext.predicateBuilders) {
                    predicateBuilder.pattern(wildcardPattern);
                }
            }
            return this;
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

