/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting.spi;

import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.EventContextElement;
import org.hibernate.search.util.common.reporting.impl.AbstractSimpleEventContextElement;
import org.jboss.logging.Messages;

public class EventContexts {
    private static final EngineEventContextMessages MESSAGES = (EngineEventContextMessages)Messages.getBundle(EngineEventContextMessages.class);
    private static final EventContext DEFAULT = EventContext.create((EventContextElement)new EventContextElement(){

        public String toString() {
            return "EventContextElement[" + this.render() + "]";
        }

        public String render() {
            return MESSAGES.defaultOnMissingContextElement();
        }
    }, (EventContextElement[])new EventContextElement[0]);
    private static final EventContext INDEX_SCHEMA_ROOT = EventContext.create((EventContextElement)new EventContextElement(){

        public String toString() {
            return "EventContextElement[" + this.render() + "]";
        }

        public String render() {
            return MESSAGES.indexSchemaRoot();
        }
    }, (EventContextElement[])new EventContextElement[0]);

    private EventContexts() {
    }

    public static EventContext getDefault() {
        return DEFAULT;
    }

    public static EventContext fromType(MappableTypeModel typeModel) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<MappableTypeModel>(typeModel){

            public String render(MappableTypeModel param) {
                String typeName = param.getName();
                return MESSAGES.type(typeName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromBackendName(String name) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(name){

            public String render(String param) {
                return MESSAGES.backend(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexName(String name) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(name){

            public String render(String param) {
                return MESSAGES.index(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexNames(String ... indexNames) {
        return EventContexts.fromIndexNames(CollectionHelper.asLinkedHashSet((Object[])indexNames));
    }

    public static EventContext fromIndexNames(Set<String> indexNames) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<Set<String>>(indexNames){

            public String render(Set<String> indexNames) {
                return MESSAGES.indexes(indexNames);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext indexSchemaRoot() {
        return INDEX_SCHEMA_ROOT;
    }

    public static EventContext fromIndexFieldAbsolutePath(String absolutePath) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(absolutePath){

            public String render(String param) {
                return MESSAGES.indexFieldAbsolutePath(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexFieldAbsolutePaths(List<String> absolutePaths) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<List<String>>(absolutePaths){

            public String render(List<String> param) {
                return MESSAGES.indexFieldAbsolutePaths(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromAnalyzer(String analyzerName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(analyzerName){

            public String render(String param) {
                String analyzerName = param == null ? "" : param;
                return MESSAGES.analyzer(analyzerName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromNormalizer(String normalizerName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(normalizerName){

            public String render(String param) {
                String normalizerName = param == null ? "" : param;
                return MESSAGES.normalizer(normalizerName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromCharFilter(String charFilterName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(charFilterName){

            public String render(String param) {
                String charFilterName = param == null ? "" : param;
                return MESSAGES.charFilter(charFilterName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromTokenizer(String tokenizerName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(tokenizerName){

            public String render(String param) {
                String tokenizerName = param == null ? "" : param;
                return MESSAGES.tokenizer(tokenizerName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromTokenFilter(String tokenFilterName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(tokenFilterName){

            public String render(String param) {
                String tokenFilterName = param == null ? "" : param;
                return MESSAGES.tokenFilter(tokenFilterName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }
}

