/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.classpath.spi;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.hibernate.search.engine.environment.classpath.impl.AggregatedClassLoader;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class DefaultClassAndResourceResolver
implements ClassResolver,
ResourceResolver {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AggregatedClassLoader aggregatedClassLoader;

    public DefaultClassAndResourceResolver() {
        ClassLoader sysClassLoader;
        LinkedHashSet<ClassLoader> orderedClassLoaderSet = new LinkedHashSet<ClassLoader>();
        orderedClassLoaderSet.add(DefaultClassAndResourceResolver.class.getClassLoader());
        ClassLoader tccl = DefaultClassAndResourceResolver.locateTCCL();
        if (tccl != null) {
            orderedClassLoaderSet.add(tccl);
        }
        if ((sysClassLoader = DefaultClassAndResourceResolver.locateSystemClassLoader()) != null) {
            orderedClassLoaderSet.add(sysClassLoader);
        }
        this.aggregatedClassLoader = new AggregatedClassLoader(orderedClassLoaderSet.toArray(new ClassLoader[0]));
    }

    @Override
    public <T> Class<T> classForName(String className) {
        try {
            return Class.forName(className, true, this.aggregatedClassLoader);
        }
        catch (Exception | LinkageError e) {
            throw log.unableToLoadTheClass(className, e);
        }
    }

    @Override
    public URL locateResource(String name) {
        try {
            return this.aggregatedClassLoader.getResource(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public InputStream locateResourceStream(String name) {
        String stripped;
        try {
            InputStream stream = this.aggregatedClassLoader.getResourceAsStream(name);
            if (stream != null) {
                return stream;
            }
        }
        catch (Exception stream) {
            // empty catch block
        }
        String string = stripped = name.startsWith("/") ? name.substring(1) : null;
        if (stripped != null) {
            try {
                return new URL(stripped).openStream();
            }
            catch (Exception exception) {
                try {
                    InputStream stream = this.aggregatedClassLoader.getResourceAsStream(stripped);
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public <S> Set<S> loadJavaServices(Class<S> serviceContract) {
        ServiceLoader<S> serviceLoader = ServiceLoader.load(serviceContract, this.aggregatedClassLoader);
        LinkedHashSet<S> services = new LinkedHashSet<S>();
        for (S service : serviceLoader) {
            services.add(service);
        }
        return services;
    }

    private static ClassLoader locateSystemClassLoader() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ClassLoader locateTCCL() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }
}

