/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.EngineSpiSettings;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.bean.impl.BeanConfigurationContextImpl;
import org.hibernate.search.engine.environment.bean.impl.BeanCreationContextImpl;
import org.hibernate.search.engine.environment.bean.impl.BeanProviderOnlyBeanResolver;
import org.hibernate.search.engine.environment.bean.impl.ConfiguredBeanKey;
import org.hibernate.search.engine.environment.bean.spi.BeanConfigurer;
import org.hibernate.search.engine.environment.bean.spi.BeanCreationContext;
import org.hibernate.search.engine.environment.bean.spi.BeanFactory;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.Contracts;

public final class ConfiguredBeanResolver
implements BeanResolver {
    private static final ConfigurationProperty<List<BeanReference<? extends BeanConfigurer>>> BEAN_CONFIGURERS = ConfigurationProperty.forKey("bean_configurers").asBeanReference(BeanConfigurer.class).multivalued(Pattern.compile("\\s+")).withDefault(EngineSpiSettings.Defaults.BEAN_CONFIGURERS).build();
    private final BeanProvider beanProvider;
    private final Map<ConfiguredBeanKey<?>, BeanFactory<?>> explicitlyConfiguredBeans;
    private final Map<Class<?>, List<? extends BeanReference<?>>> roleMap;
    private final BeanCreationContext beanCreationContext;

    public ConfiguredBeanResolver(ClassResolver classResolver, BeanProvider beanProvider, ConfigurationPropertySource configurationPropertySource) {
        this.beanProvider = beanProvider;
        BeanConfigurationContextImpl configurationContext = new BeanConfigurationContextImpl();
        for (BeanConfigurer beanConfigurer : classResolver.loadJavaServices(BeanConfigurer.class)) {
            beanConfigurer.configure(configurationContext);
        }
        BeanProviderOnlyBeanResolver beanResolverForConfigurers = new BeanProviderOnlyBeanResolver(beanProvider);
        try (BeanHolder beanConfigurersFromConfigurationProperties = BEAN_CONFIGURERS.getAndTransform(configurationPropertySource, beanResolverForConfigurers::resolve);){
            for (BeanConfigurer beanConfigurer : (List)beanConfigurersFromConfigurationProperties.get()) {
                beanConfigurer.configure(configurationContext);
            }
        }
        this.explicitlyConfiguredBeans = configurationContext.getConfiguredBeans();
        this.roleMap = configurationContext.getRoleMap();
        this.beanCreationContext = new BeanCreationContextImpl(this);
    }

    @Override
    public <T> BeanHolder<T> resolve(Class<T> typeReference) {
        Contracts.assertNotNull(typeReference, (String)"typeReference");
        try {
            return this.beanProvider.getBean(typeReference);
        }
        catch (SearchException e) {
            return this.fallbackToConfiguredBeans(e, typeReference, null);
        }
    }

    @Override
    public <T> BeanHolder<T> resolve(Class<T> typeReference, String nameReference) {
        Contracts.assertNotNull(typeReference, (String)"typeReference");
        Contracts.assertNotNullNorEmpty((String)nameReference, (String)"nameReference");
        try {
            return this.beanProvider.getBean(typeReference, nameReference);
        }
        catch (SearchException e) {
            return this.fallbackToConfiguredBeans(e, typeReference, nameReference);
        }
    }

    @Override
    public <T> BeanHolder<List<T>> resolveRole(Class<T> role) {
        Contracts.assertNotNull(role, (String)"role");
        List<BeanReference<?>> references = this.roleMap.get(role);
        if (references == null || references.isEmpty()) {
            return BeanHolder.of(Collections.emptyList());
        }
        return this.resolve(references);
    }

    private <T> BeanHolder<T> fallbackToConfiguredBeans(SearchException e, Class<T> typeReference, String nameReference) {
        try {
            BeanHolder<T> explicitlyConfiguredBean = this.getExplicitlyConfiguredBean(typeReference, nameReference);
            if (explicitlyConfiguredBean != null) {
                return explicitlyConfiguredBean;
            }
        }
        catch (RuntimeException e2) {
            e.addSuppressed((Throwable)e2);
        }
        throw e;
    }

    private <T> BeanHolder<T> getExplicitlyConfiguredBean(Class<T> exposedType, String name) {
        ConfiguredBeanKey<T> key = new ConfiguredBeanKey<T>(exposedType, name);
        BeanFactory<?> factory = this.explicitlyConfiguredBeans.get(key);
        if (factory == null) {
            return null;
        }
        return factory.create(this.beanCreationContext);
    }
}

