/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.common.impl.BackendPartialBuildState;
import org.hibernate.search.engine.common.impl.IndexManagerPartialBuildState;
import org.hibernate.search.engine.common.impl.SearchIntegrationImpl;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappingKey;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPartialBuildState;
import org.hibernate.search.engine.reporting.impl.RootFailureCollector;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;

class SearchIntegrationPartialBuildStateImpl
implements SearchIntegrationPartialBuildState {
    private static final int FAILURE_LIMIT = 100;
    private final BeanProvider beanProvider;
    private final Map<MappingKey<?, ?>, MappingPartialBuildState> partiallyBuiltMappings;
    private final Map<MappingKey<?, ?>, MappingImplementor<?>> fullyBuiltMappings = new LinkedHashMap();
    private final Map<String, BackendPartialBuildState> partiallyBuiltBackends;
    private final Map<String, BackendImplementor<?>> fullyBuiltBackends = new LinkedHashMap();
    private final Map<String, IndexManagerPartialBuildState> partiallyBuiltIndexManagers;
    private final Map<String, IndexManagerImplementor<?>> fullyBuiltIndexManagers = new LinkedHashMap();

    SearchIntegrationPartialBuildStateImpl(BeanProvider beanProvider, Map<MappingKey<?, ?>, MappingPartialBuildState> partiallyBuiltMappings, Map<String, BackendPartialBuildState> partiallyBuiltBackends, Map<String, IndexManagerPartialBuildState> partiallyBuiltIndexManagers) {
        this.beanProvider = beanProvider;
        this.partiallyBuiltMappings = partiallyBuiltMappings;
        this.partiallyBuiltBackends = partiallyBuiltBackends;
        this.partiallyBuiltIndexManagers = partiallyBuiltIndexManagers;
    }

    @Override
    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(MappingPartialBuildState::closeOnFailure, this.partiallyBuiltMappings.values());
            closer.pushAll(MappingImplementor::close, this.fullyBuiltMappings.values());
            closer.pushAll(IndexManagerPartialBuildState::closeOnFailure, this.partiallyBuiltIndexManagers.values());
            closer.pushAll(IndexManagerImplementor::close, this.fullyBuiltIndexManagers.values());
            closer.pushAll(BackendPartialBuildState::closeOnFailure, this.partiallyBuiltBackends.values());
            closer.pushAll(BackendImplementor::close, this.fullyBuiltBackends.values());
            closer.pushAll(BeanProvider::close, (Object[])new BeanProvider[]{this.beanProvider});
        }
    }

    @Override
    public <PBM, M> M finalizeMapping(MappingKey<PBM, M> mappingKey, Function<PBM, MappingImplementor<M>> director) {
        MappingPartialBuildState partiallyBuiltMapping = this.partiallyBuiltMappings.get(mappingKey);
        if (partiallyBuiltMapping == null) {
            throw new AssertionFailure("Some partially built mapping could not be found during bootstrap; there is probably a bug in Hibernate Search. Key: " + mappingKey);
        }
        MappingImplementor<M> mapping = director.apply(partiallyBuiltMapping);
        this.fullyBuiltMappings.put(mappingKey, mapping);
        this.partiallyBuiltMappings.remove(mappingKey);
        return mapping.toConcreteType();
    }

    @Override
    public SearchIntegration finalizeIntegration(ConfigurationPropertySource configurationPropertySource) {
        if (!this.partiallyBuiltMappings.isEmpty()) {
            throw new AssertionFailure("Some mappings were not fully built; there is probably a bug in Hibernate Search. Partially built mappings: " + this.partiallyBuiltMappings);
        }
        RootFailureCollector failureCollector = new RootFailureCollector(100);
        for (Map.Entry<String, BackendPartialBuildState> entry : this.partiallyBuiltBackends.entrySet()) {
            this.fullyBuiltBackends.put(entry.getKey(), entry.getValue().finalizeBuild(failureCollector, configurationPropertySource));
        }
        failureCollector.checkNoFailure();
        for (Map.Entry<String, Object> entry : this.partiallyBuiltIndexManagers.entrySet()) {
            this.fullyBuiltIndexManagers.put(entry.getKey(), ((IndexManagerPartialBuildState)entry.getValue()).finalizeBuild(failureCollector, configurationPropertySource));
        }
        failureCollector.checkNoFailure();
        return new SearchIntegrationImpl(this.beanProvider, this.fullyBuiltMappings, this.fullyBuiltBackends, this.fullyBuiltIndexManagers);
    }
}

