/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScope;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.DefaultSearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.impl.DefaultSearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultDefinitionContext;
import org.hibernate.search.engine.search.dsl.query.impl.DefaultSearchQueryResultDefinitionContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryContext;
import org.hibernate.search.engine.search.dsl.sort.impl.DefaultSearchSortFactoryContext;
import org.hibernate.search.engine.search.dsl.sort.impl.SearchSortDslContextImpl;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;

class MappedIndexScopeImpl<C, R, E>
implements MappedIndexScope<R, E> {
    private final IndexScope<C> delegate;

    MappedIndexScopeImpl(IndexScope<C> delegate) {
        this.delegate = delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "delegate=" + this.delegate + "]";
    }

    @Override
    public SearchQueryResultDefinitionContext<?, R, E, SearchProjectionFactoryContext<R, E>, ?> search(SessionContextImplementor sessionContext, LoadingContextBuilder<R, E> loadingContextBuilder) {
        return new DefaultSearchQueryResultDefinitionContext<R, E, C>(this.delegate, sessionContext, loadingContextBuilder);
    }

    @Override
    public SearchPredicateFactoryContext predicate() {
        return new DefaultSearchPredicateFactoryContext(this.delegate.getSearchPredicateBuilderFactory());
    }

    @Override
    public SearchSortFactoryContext sort() {
        return new DefaultSearchSortFactoryContext(SearchSortDslContextImpl.root(this.delegate.getSearchSortBuilderFactory()));
    }

    @Override
    public SearchProjectionFactoryContext<R, E> projection() {
        return new DefaultSearchProjectionFactoryContext(this.delegate.getSearchProjectionFactory());
    }
}

