/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldContext;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaObjectField;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaNestingContext;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaObjectFieldImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactoryContext;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeTerminalContext;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.impl.StringHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IndexSchemaElementImpl<B extends IndexSchemaObjectNodeBuilder>
implements IndexSchemaElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeFactoryContext typeFactoryContext;
    final B objectNodeBuilder;
    private final IndexSchemaNestingContext nestingContext;
    private final boolean directChildrenAreMultiValuedByDefault;

    public IndexSchemaElementImpl(IndexFieldTypeFactoryContext typeFactoryContext, B objectNodeBuilder, IndexSchemaNestingContext nestingContext, boolean directChildrenAreMultiValuedByDefault) {
        this.typeFactoryContext = typeFactoryContext;
        this.objectNodeBuilder = objectNodeBuilder;
        this.nestingContext = nestingContext;
        this.directChildrenAreMultiValuedByDefault = directChildrenAreMultiValuedByDefault;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "objectNodeBuilder=" + this.objectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public <F> IndexSchemaFieldContext<?, IndexFieldReference<F>> field(String relativeFieldName, IndexFieldType<F> type) {
        this.checkRelativeFieldName(relativeFieldName);
        IndexSchemaFieldContext fieldContext = this.nestingContext.nest(relativeFieldName, prefixedName -> this.objectNodeBuilder.addField((String)prefixedName, type), prefixedName -> this.objectNodeBuilder.createExcludedField((String)prefixedName, type));
        if (this.directChildrenAreMultiValuedByDefault) {
            fieldContext.multiValued();
        }
        return fieldContext;
    }

    @Override
    public <F> IndexSchemaFieldContext<?, IndexFieldReference<F>> field(String relativeFieldName, Function<? super IndexFieldTypeFactoryContext, ? extends IndexFieldTypeTerminalContext<F>> typeContributor) {
        return this.field(relativeFieldName, typeContributor.apply(this.typeFactoryContext));
    }

    @Override
    public IndexSchemaObjectField objectField(String relativeFieldName, ObjectFieldStorage storage) {
        this.checkRelativeFieldName(relativeFieldName);
        IndexSchemaObjectField fieldContext = this.nestingContext.nest(relativeFieldName, (prefixedName, filter) -> {
            IndexSchemaObjectFieldNodeBuilder objectFieldBuilder = this.objectNodeBuilder.addObjectField((String)prefixedName, storage);
            return new IndexSchemaObjectFieldImpl(this.typeFactoryContext, objectFieldBuilder, (IndexSchemaNestingContext)filter, false);
        }, (prefixedName, filter) -> {
            IndexSchemaObjectFieldNodeBuilder objectFieldBuilder = this.objectNodeBuilder.createExcludedObjectField((String)prefixedName, storage);
            return new IndexSchemaObjectFieldImpl(this.typeFactoryContext, objectFieldBuilder, (IndexSchemaNestingContext)filter, false);
        });
        if (this.directChildrenAreMultiValuedByDefault) {
            fieldContext.multiValued();
        }
        return fieldContext;
    }

    private void checkRelativeFieldName(String relativeFieldName) {
        if (StringHelper.isEmpty((String)relativeFieldName)) {
            throw log.relativeFieldNameCannotBeNullOrEmpty(relativeFieldName, this.objectNodeBuilder.getEventContext());
        }
        if (relativeFieldName.contains(".")) {
            throw log.relativeFieldNameCannotContainDot(relativeFieldName, this.objectNodeBuilder.getEventContext());
        }
    }
}

