/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.sort.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.engine.search.dsl.sort.spi.SearchSortContributor;
import org.hibernate.search.engine.search.dsl.sort.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilderFactory;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class SearchSortDslContextImpl<B>
implements SearchSortDslContext<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final SearchSortBuilderFactory<?, B> factory;
    private final List<SearchSortContributor<? extends B>> sortContributors = new ArrayList<SearchSortContributor<? extends B>>();
    private SearchSort sortResult;
    private boolean usedContributors = false;

    public SearchSortDslContextImpl(SearchSortBuilderFactory<?, B> factory) {
        this.factory = factory;
    }

    @Override
    public void addChild(SearchSortContributor<? extends B> child) {
        if (this.usedContributors) {
            throw log.cannotAddSortToUsedContext();
        }
        this.sortContributors.add(child);
    }

    @Override
    public SearchSort toSort() {
        if (this.sortResult == null) {
            if (this.usedContributors) {
                throw new AssertionFailure("A sort object was requested after the corresponding information was contributed to the DSL. There is a bug in Hibernate Search, please report it.");
            }
            List<B> builderResult = this.getResultingBuilders();
            this.sortResult = this.factory.toSearchSort(builderResult);
        }
        return this.sortResult;
    }

    public List<B> getResultingBuilders() {
        ArrayList builderResult = new ArrayList();
        if (this.sortResult != null) {
            this.factory.toImplementation(this.sortResult, builderResult::add);
        } else {
            if (this.usedContributors) {
                throw new AssertionFailure("A sort contributor was called twice. There is a bug in Hibernate Search, please report it.");
            }
            this.usedContributors = true;
            for (SearchSortContributor<Object> searchSortContributor : this.sortContributors) {
                searchSortContributor.contribute(builderResult::add);
            }
        }
        return builderResult;
    }
}

