/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.projection;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.projection.CompositeProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.DistanceToFieldProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.DocumentReferenceProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.FieldProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.ObjectProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.ReferenceProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.ScoreProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContextExtension;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryExtensionContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionTerminalContext;
import org.hibernate.search.engine.search.projection.ProjectionConverter;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.function.TriFunction;

public interface SearchProjectionFactoryContext<R, O> {
    public DocumentReferenceProjectionContext documentReference();

    public ReferenceProjectionContext<R> reference();

    public ObjectProjectionContext<O> object();

    default public <T> FieldProjectionContext<T> field(String absoluteFieldPath, Class<T> type) {
        return this.field(absoluteFieldPath, type, ProjectionConverter.ENABLED);
    }

    public <T> FieldProjectionContext<T> field(String var1, Class<T> var2, ProjectionConverter var3);

    default public FieldProjectionContext<Object> field(String absoluteFieldPath) {
        return this.field(absoluteFieldPath, ProjectionConverter.ENABLED);
    }

    public FieldProjectionContext<Object> field(String var1, ProjectionConverter var2);

    public ScoreProjectionContext score();

    public DistanceToFieldProjectionContext distance(String var1, GeoPoint var2);

    default public CompositeProjectionContext<List<?>> composite(SearchProjection<?> ... projections) {
        return this.composite(Function.identity(), projections);
    }

    default public CompositeProjectionContext<List<?>> composite(SearchProjectionTerminalContext<?> ... terminalContexts) {
        return this.composite(Function.identity(), terminalContexts);
    }

    public <T> CompositeProjectionContext<T> composite(Function<List<?>, T> var1, SearchProjection<?> ... var2);

    default public <T> CompositeProjectionContext<T> composite(Function<List<?>, T> transformer, SearchProjectionTerminalContext<?> ... terminalContexts) {
        SearchProjection[] projections = new SearchProjection[terminalContexts.length];
        for (int i = 0; i < terminalContexts.length; ++i) {
            projections[i] = terminalContexts[i].toProjection();
        }
        return this.composite(transformer, projections);
    }

    public <P, T> CompositeProjectionContext<T> composite(Function<P, T> var1, SearchProjection<P> var2);

    default public <P, T> CompositeProjectionContext<T> composite(Function<P, T> transformer, SearchProjectionTerminalContext<P> terminalContext) {
        return this.composite(transformer, terminalContext.toProjection());
    }

    public <P1, P2, T> CompositeProjectionContext<T> composite(BiFunction<P1, P2, T> var1, SearchProjection<P1> var2, SearchProjection<P2> var3);

    default public <P1, P2, T> CompositeProjectionContext<T> composite(BiFunction<P1, P2, T> transformer, SearchProjectionTerminalContext<P1> terminalContext1, SearchProjectionTerminalContext<P2> terminalContext2) {
        return this.composite(transformer, terminalContext1.toProjection(), terminalContext2.toProjection());
    }

    public <P1, P2, P3, T> CompositeProjectionContext<T> composite(TriFunction<P1, P2, P3, T> var1, SearchProjection<P1> var2, SearchProjection<P2> var3, SearchProjection<P3> var4);

    default public <P1, P2, P3, T> CompositeProjectionContext<T> composite(TriFunction<P1, P2, P3, T> transformer, SearchProjectionTerminalContext<P1> terminalContext1, SearchProjectionTerminalContext<P2> terminalContext2, SearchProjectionTerminalContext<P3> terminalContext3) {
        return this.composite(transformer, terminalContext1.toProjection(), terminalContext2.toProjection(), terminalContext3.toProjection());
    }

    public <T> T extension(SearchProjectionFactoryContextExtension<T, R, O> var1);

    public <T> SearchProjectionFactoryExtensionContext<T, R, O> extension();
}

