/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.util.common.impl.Contracts;

class TypeBeanReference<T>
implements BeanReference<T> {
    final Class<T> type;

    TypeBeanReference(Class<T> type) {
        Contracts.assertNotNull(type, (String)"type");
        this.type = type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + this.type + "]";
    }

    @Override
    public BeanHolder<T> getBean(BeanProvider beanProvider) {
        return beanProvider.getBean(this.type);
    }

    @Override
    public <U> BeanReference<? extends U> asSubTypeOf(Class<U> expectedType) {
        if (expectedType.isAssignableFrom(this.type)) {
            return this;
        }
        return BeanReference.super.asSubTypeOf(expectedType);
    }
}

