/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.CastingBeanReference;
import org.hibernate.search.engine.environment.bean.InstanceBeanReference;
import org.hibernate.search.engine.environment.bean.TypeAndNameBeanReference;
import org.hibernate.search.engine.environment.bean.TypeBeanReference;
import org.hibernate.search.util.common.impl.StringHelper;

public interface BeanReference<T> {
    public BeanHolder<T> getBean(BeanProvider var1);

    default public <U> BeanReference<? extends U> asSubTypeOf(Class<U> expectedType) {
        return new CastingBeanReference<U>(this, expectedType);
    }

    public static <T> BeanReference<T> of(Class<T> type) {
        return new TypeBeanReference<T>(type);
    }

    public static <T> BeanReference<T> of(Class<T> type, String name) {
        if (StringHelper.isNotEmpty((String)name)) {
            return new TypeAndNameBeanReference<T>(type, name);
        }
        return new TypeBeanReference<T>(type);
    }

    public static <T> BeanReference<T> ofInstance(T instance) {
        return new InstanceBeanReference<T>(instance);
    }
}

