/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public interface BeanProvider {
    public <T> BeanHolder<T> getBean(Class<T> var1);

    public <T> BeanHolder<T> getBean(Class<T> var1, String var2);

    default public <T> BeanHolder<T> getBean(BeanReference<T> reference) {
        Contracts.assertNotNull(reference, (String)"reference");
        return reference.getBean(this);
    }

    default public <T> BeanHolder<List<T>> getBeans(List<? extends BeanReference<? extends T>> references) {
        ArrayList<BeanHolder<? extends T>> beanHolders = new ArrayList<BeanHolder<? extends T>>();
        try {
            for (BeanReference<T> reference : references) {
                beanHolders.add(reference.getBean(this));
            }
            return BeanHolder.of(beanHolders);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(BeanHolder::close, beanHolders);
            throw e;
        }
    }

    public <T> BeanHolder<List<T>> getBeansWithRole(Class<T> var1);
}

