/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.engine.backend.types.dsl;

import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

/**
 * @param <S> The concrete type of this context.
 * @param <F> The type of field values.
 */
public interface IndexFieldTypeConverterContext<S extends IndexFieldTypeConverterContext<? extends S, F>, F> {

	S dslConverter(ToDocumentFieldValueConverter<?, ? extends F> toIndexConverter);

	S projectionConverter(FromDocumentFieldValueConverter<? super F, ?> fromIndexConverter);

}
