/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.DefaultSearchPredicateFactoryContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class SearchQueryPredicateCollector<C, B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SearchPredicateBuilderFactory<C, B> factory;
    private B builder;

    SearchQueryPredicateCollector(SearchPredicateBuilderFactory<C, B> factory) {
        this.factory = factory;
    }

    void contribute(C collector) {
        this.factory.contribute(collector, this.builder);
    }

    void collect(SearchPredicate predicate) {
        this.collect(this.factory.toImplementation(predicate));
    }

    void collect(Function<? super SearchPredicateFactoryContext, SearchPredicateTerminalContext> dslPredicateContributor) {
        DefaultSearchPredicateFactoryContext<B> factoryContext = new DefaultSearchPredicateFactoryContext<B>(this.factory);
        this.collect(dslPredicateContributor.apply(factoryContext).toPredicate());
    }

    private void collect(B builder) {
        if (this.builder != null) {
            throw log.cannotAddMultiplePredicatesToQueryRoot();
        }
        this.builder = builder;
    }
}

