/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.query.impl;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.engine.search.dsl.query.SearchQueryContext;
import org.hibernate.search.engine.search.dsl.query.impl.SearchQueryPredicateCollector;
import org.hibernate.search.engine.search.dsl.query.impl.SearchQuerySortCollector;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContext;
import org.hibernate.search.engine.search.dsl.spi.IndexSearchScope;
import org.hibernate.search.engine.search.query.spi.IndexSearchQuery;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public final class SearchQueryContextImpl<T, Q, C>
implements SearchQueryContext<Q> {
    private final SearchQueryBuilder<T, C> searchQueryBuilder;
    private final Function<IndexSearchQuery<T>, Q> searchQueryWrapperFactory;
    private final SearchQueryPredicateCollector<? super C, ?> searchPredicateCollector;
    private final SearchQuerySortCollector<? super C, ?> searchSortCollector;

    public SearchQueryContextImpl(IndexSearchScope<C> targetContext, SearchQueryBuilder<T, C> searchQueryBuilder, Function<IndexSearchQuery<T>, Q> searchQueryWrapperFactory, SearchQueryPredicateCollector<? super C, ?> searchPredicateCollector) {
        this.searchQueryBuilder = searchQueryBuilder;
        this.searchQueryWrapperFactory = searchQueryWrapperFactory;
        this.searchPredicateCollector = searchPredicateCollector;
        this.searchSortCollector = new SearchQuerySortCollector(targetContext.getSearchSortBuilderFactory());
    }

    @Override
    public SearchQueryContext<Q> routing(String routingKey) {
        this.searchQueryBuilder.addRoutingKey(routingKey);
        return this;
    }

    @Override
    public SearchQueryContext<Q> routing(Collection<String> routingKeys) {
        routingKeys.forEach(this.searchQueryBuilder::addRoutingKey);
        return this;
    }

    @Override
    public SearchQueryContext<Q> sort(SearchSort sort) {
        this.searchSortCollector.collect(sort);
        return this;
    }

    @Override
    public SearchQueryContext<Q> sort(Consumer<? super SearchSortContainerContext> dslSortContributor) {
        this.searchSortCollector.collect(dslSortContributor);
        return this;
    }

    @Override
    public Q toQuery() {
        C collector = this.searchQueryBuilder.getQueryElementCollector();
        this.searchPredicateCollector.contribute(collector);
        this.searchSortCollector.contribute(collector);
        return this.searchQueryBuilder.build(this.searchQueryWrapperFactory);
    }
}

