/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateFieldSetContext;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateFromContext;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateLimitTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class RangePredicateFieldSetContextImpl<B>
implements RangePredicateFieldSetContext,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetContext<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<RangePredicateBuilder<B>> predicateBuilders = new ArrayList<RangePredicateBuilder<B>>();
    private Float fieldSetBoost;

    RangePredicateFieldSetContextImpl(CommonState<B> commonState, List<String> absoluteFieldPaths, DslConverter dslConverter) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.range(absoluteFieldPath, dslConverter));
        }
    }

    @Override
    public RangePredicateFieldSetContext orFields(String ... absoluteFieldPaths) {
        return new RangePredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths), DslConverter.ENABLED);
    }

    @Override
    public RangePredicateFieldSetContext orRawFields(String ... absoluteFieldPaths) {
        return new RangePredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths), DslConverter.DISABLED);
    }

    @Override
    public RangePredicateFieldSetContext boostedTo(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public RangePredicateFromContext from(Object value) {
        return this.commonState.from(value);
    }

    @Override
    public RangePredicateLimitTerminalContext above(Object value) {
        return this.commonState.above(value);
    }

    @Override
    public RangePredicateLimitTerminalContext below(Object value) {
        return this.commonState.below(value);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (RangePredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class RangePredicateFromContextImpl<B>
    implements RangePredicateFromContext {
        private final CommonState<B> delegate;

        RangePredicateFromContextImpl(CommonState<B> delegate) {
            this.delegate = delegate;
        }

        @Override
        public RangePredicateLimitTerminalContext to(Object value) {
            ((CommonState)this.delegate).doBelow(value);
            ((CommonState)this.delegate).checkHasNonNullBound();
            return this.delegate;
        }

        @Override
        public RangePredicateFromContext excludeLimit() {
            ((CommonState)this.delegate).getQueryBuilders().forEach(RangePredicateBuilder::excludeLowerLimit);
            return this;
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, RangePredicateFieldSetContextImpl<B>>
    implements RangePredicateLimitTerminalContext {
        private boolean hasNonNullBound = false;
        protected boolean excludeUpperLimit = false;

        CommonState(SearchPredicateBuilderFactory<?, B> factory) {
            super(factory);
        }

        @Override
        public RangePredicateTerminalContext excludeLimit() {
            this.getQueryBuilders().forEach(this.excludeUpperLimit ? RangePredicateBuilder::excludeUpperLimit : RangePredicateBuilder::excludeLowerLimit);
            return this;
        }

        @Override
        protected B toImplementation() {
            this.checkHasNonNullBound();
            return super.toImplementation();
        }

        RangePredicateFromContext from(Object value) {
            this.doAbove(value);
            return new RangePredicateFromContextImpl(this);
        }

        RangePredicateLimitTerminalContext above(Object value) {
            this.doAbove(value);
            this.checkHasNonNullBound();
            return this;
        }

        RangePredicateLimitTerminalContext below(Object value) {
            this.doBelow(value);
            this.checkHasNonNullBound();
            return this;
        }

        private void doAbove(Object value) {
            this.excludeUpperLimit = false;
            if (value != null) {
                this.hasNonNullBound = true;
                this.getQueryBuilders().forEach(q -> q.lowerLimit(value));
            }
        }

        private void doBelow(Object value) {
            this.excludeUpperLimit = true;
            if (value != null) {
                this.hasNonNullBound = true;
                this.getQueryBuilders().forEach(q -> q.upperLimit(value));
            }
        }

        private void checkHasNonNullBound() {
            if (!this.hasNonNullBound) {
                throw log.rangePredicateCannotMatchNullValue(this.getEventContext());
            }
        }

        private Stream<RangePredicateBuilder<B>> getQueryBuilders() {
            return this.getFieldSetContexts().stream().flatMap(f -> ((RangePredicateFieldSetContextImpl)f).predicateBuilders.stream());
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

