/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.PhrasePredicateFieldSetContext;
import org.hibernate.search.engine.search.dsl.predicate.PhrasePredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PhrasePredicateFieldSetContextImpl<B>
implements PhrasePredicateFieldSetContext,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetContext<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<PhrasePredicateBuilder<B>> predicateBuilders = new ArrayList<PhrasePredicateBuilder<B>>();
    private Float fieldSetBoost;

    PhrasePredicateFieldSetContextImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.phrase(absoluteFieldPath));
        }
    }

    @Override
    public PhrasePredicateFieldSetContext orFields(String ... absoluteFieldPaths) {
        return new PhrasePredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public PhrasePredicateFieldSetContext boostedTo(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public PhrasePredicateTerminalContext matching(String phrase) {
        return ((CommonState)this.commonState).matching(phrase);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (PhrasePredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, PhrasePredicateFieldSetContextImpl<B>>
    implements PhrasePredicateTerminalContext {
        CommonState(SearchPredicateBuilderFactory<?, B> factory) {
            super(factory);
        }

        private PhrasePredicateTerminalContext matching(String phrase) {
            if (phrase == null) {
                throw log.phrasePredicateCannotMatchNullPhrase(this.getEventContext());
            }
            for (PhrasePredicateFieldSetContextImpl fieldSetContext : this.getFieldSetContexts()) {
                for (PhrasePredicateBuilder predicateBuilder : fieldSetContext.predicateBuilders) {
                    predicateBuilder.phrase(phrase);
                }
            }
            return this;
        }

        @Override
        public PhrasePredicateTerminalContext withSlop(int slop) {
            if (slop < 0) {
                throw log.invalidPhrasePredicateSlop(slop);
            }
            for (PhrasePredicateFieldSetContextImpl fieldSetContext : this.getFieldSetContexts()) {
                for (PhrasePredicateBuilder predicateBuilder : fieldSetContext.predicateBuilders) {
                    predicateBuilder.slop(slop);
                }
            }
            return this;
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

