/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.EngineConfigurationUtils;
import org.hibernate.search.engine.common.impl.IndexManagerStartContextImpl;
import org.hibernate.search.engine.reporting.impl.RootFailureCollector;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;

class IndexManagerPartialBuildState {
    private final String backendName;
    private final String indexName;
    private final IndexManagerImplementor<?> partiallyBuiltIndexManager;

    IndexManagerPartialBuildState(String backendName, String indexName, IndexManagerImplementor<?> partiallyBuiltIndexManager) {
        this.backendName = backendName;
        this.indexName = indexName;
        this.partiallyBuiltIndexManager = partiallyBuiltIndexManager;
    }

    void closeOnFailure() {
        this.partiallyBuiltIndexManager.close();
    }

    IndexManagerImplementor<?> finalizeBuild(RootFailureCollector rootFailureCollector, ConfigurationPropertySource rootPropertySource) {
        ContextualFailureCollector indexFailureCollector = rootFailureCollector.withContext(EventContexts.fromIndexName(this.indexName));
        ConfigurationPropertySource indexPropertySource = EngineConfigurationUtils.addIndexDefaults(EngineConfigurationUtils.getIndexWithoutDefaults(rootPropertySource, this.indexName), EngineConfigurationUtils.getIndexDefaults(EngineConfigurationUtils.getBackend(rootPropertySource, this.backendName)));
        IndexManagerStartContextImpl startContext = new IndexManagerStartContextImpl(indexFailureCollector, indexPropertySource);
        try {
            this.partiallyBuiltIndexManager.start(startContext);
        }
        catch (RuntimeException e) {
            indexFailureCollector.add(e);
        }
        return this.partiallyBuiltIndexManager;
    }
}

