/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.lowlevel.impl;

import java.util.Collection;
import java.util.function.ToLongFunction;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public record EffectiveRange(long min, long max) {
    public static <T extends Number> EffectiveRange[] createEffectiveRangesForIntegralValues(Collection<? extends Range<? extends T>> ranges) {
        return EffectiveRange.createEffectiveRangesForIntegralValues(ranges, Number::longValue, Long.MIN_VALUE, Long.MAX_VALUE, false);
    }

    public static <T extends Number> EffectiveRange[] createEffectiveRangesForIntegralValues(Collection<? extends Range<? extends T>> ranges, ToLongFunction<T> encoder, T negativeInfinity, T positiveInfinity) {
        return EffectiveRange.createEffectiveRangesForIntegralValues(ranges, encoder, negativeInfinity, positiveInfinity, true);
    }

    private static <T> EffectiveRange[] createEffectiveRangesForIntegralValues(Collection<? extends Range<? extends T>> ranges, ToLongFunction<T> encoder, T lowestPossibleValue, T highestPossibleValue, boolean extremaAreInfinity) {
        EffectiveRange[] effectiveRanges = new EffectiveRange[ranges.size()];
        int i = 0;
        for (Range<T> range : ranges) {
            Object lowerBoundValue = range.lowerBoundValue().orElse(null);
            Object upperBoundValue = range.upperBoundValue().orElse(null);
            long min = encoder.applyAsLong(lowerBoundValue == null ? lowestPossibleValue : lowerBoundValue);
            long max = encoder.applyAsLong(upperBoundValue == null ? highestPossibleValue : upperBoundValue);
            if (RangeBoundInclusion.EXCLUDED.equals((Object)range.lowerBoundInclusion()) && (extremaAreInfinity || lowerBoundValue != null)) {
                ++min;
            }
            if (RangeBoundInclusion.EXCLUDED.equals((Object)range.upperBoundInclusion()) && (extremaAreInfinity || upperBoundValue != null)) {
                --max;
            }
            effectiveRanges[i] = new EffectiveRange(min, max);
            ++i;
        }
        return effectiveRanges;
    }
}

