/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermResults;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TextTermsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TextTermsCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TextTermsCollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningTextMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneMultivaluedTermsAggregation;
import org.hibernate.search.backend.lucene.types.aggregation.impl.Bucket;
import org.hibernate.search.backend.lucene.types.aggregation.impl.BucketOrder;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LocalAggregationExtractContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LocalAggregationRequestContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LongBucket;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneCountDocumentAggregation;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class LuceneTextTermsAggregation<K, R>
extends AbstractLuceneMultivaluedTermsAggregation<String, String, K, String, R> {
    private static final Comparator<String> STRING_COMPARATOR = Comparator.naturalOrder();
    private CollectorKey<TextTermsCollector, TermResults> collectorKey;

    private LuceneTextTermsAggregation(Builder<K, R> builder) {
        super(builder);
    }

    @Override
    public LuceneSearchAggregation.Extractor<Map<K, R>> request(AggregationRequestContext context) {
        NestedDocsProvider nestedDocsProvider = this.createNestedDocsProvider(context);
        JoiningTextMultiValuesSource source = JoiningTextMultiValuesSource.fromField(this.absoluteFieldPath, nestedDocsProvider);
        LocalAggregationRequestContext localAggregationContext = new LocalAggregationRequestContext(context);
        LuceneSearchAggregation.Extractor extractor = this.aggregation.request(localAggregationContext);
        CollectorFactory<TextTermsCollector, TermResults, TextTermsCollectorManager> termsCollectorFactory = TextTermsCollectorFactory.instance(this.absoluteFieldPath, source, localAggregationContext.localCollectorFactories());
        context.requireCollector(termsCollectorFactory);
        this.collectorKey = termsCollectorFactory.getCollectorKey();
        return new LuceneTextTermsAggregationExtractor(extractor);
    }

    private class LuceneTextTermsAggregationExtractor
    extends AbstractLuceneMultivaluedTermsAggregation.AbstractExtractor {
        private LuceneTextTermsAggregationExtractor(LuceneSearchAggregation.Extractor<R> extractor) {
            super(extractor);
        }

        @Override
        protected TermResults termResults(AggregationExtractContext context) throws IOException {
            return context.getCollectorResults(LuceneTextTermsAggregation.this.collectorKey);
        }

        Set<String> collectFirstTerms(IndexReader reader, boolean descending, int limit) throws IOException {
            TreeSet<String> collectedTerms = new TreeSet<String>(descending ? STRING_COMPARATOR.reversed() : STRING_COMPARATOR);
            for (LeafReaderContext leaf : reader.leaves()) {
                int i;
                LeafReader atomicReader = leaf.reader();
                SortedSetDocValues docValues = atomicReader.getSortedSetDocValues(LuceneTextTermsAggregation.this.absoluteFieldPath);
                if (docValues == null) continue;
                int valueCount = (int)docValues.getValueCount();
                if (descending) {
                    int start;
                    for (i = start = Math.max(0, valueCount - limit); i < valueCount; ++i) {
                        collectedTerms.add(docValues.lookupOrd((long)i).utf8ToString());
                    }
                    continue;
                }
                int end = Math.min(limit, valueCount);
                for (i = 0; i < end; ++i) {
                    collectedTerms.add(docValues.lookupOrd((long)i).utf8ToString());
                }
            }
            return collectedTerms;
        }

        Comparator<String> getAscendingTermComparator() {
            return STRING_COMPARATOR;
        }

        String termToFieldValue(String key) {
            return key;
        }

        List<Bucket<String, R>> getTopBuckets(AggregationExtractContext context) throws IOException {
            TermResults termResults = context.getCollectorResults(LuceneTextTermsAggregation.this.collectorKey);
            LocalAggregationExtractContext localContext = new LocalAggregationExtractContext(context);
            List<LongBucket> results = termResults.counts(LuceneTextTermsAggregation.this.order, LuceneTextTermsAggregation.this.maxTermCount, LuceneTextTermsAggregation.this.minDocCount);
            SortedSetDocValues dv = MultiDocValues.getSortedSetValues((IndexReader)context.getIndexReader(), (String)LuceneTextTermsAggregation.this.absoluteFieldPath);
            ArrayList buckets = new ArrayList();
            for (LongBucket bucket : results) {
                localContext.setResults(this.prepareResults(bucket, termResults));
                buckets.add(new Bucket(dv.lookupOrd(bucket.termOrd()).utf8ToString(), bucket.count(), this.extractor.extract(localContext)));
            }
            return buckets;
        }
    }

    private static class Builder<K, V>
    extends AbstractLuceneMultivaluedTermsAggregation.AbstractBuilder<String, String, K, String, V> {
        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<String> field, LuceneSearchAggregation<V> aggregation, ProjectionConverter<String, ? extends K> fromFieldValueConverter) {
            super(scope, field, aggregation, fromFieldValueConverter);
        }

        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field, LuceneSearchAggregation<V> aggregation, ProjectionConverter<String, ? extends K> fromFieldValueConverter, BucketOrder order, int minDocCount, int maxTermCount) {
            super(scope, field, aggregation, fromFieldValueConverter, order, minDocCount, maxTermCount);
        }

        @Override
        public LuceneTextTermsAggregation<K, V> build() {
            return new LuceneTextTermsAggregation(this);
        }

        public <T> TermsAggregationBuilder<K, T> withValue(SearchAggregation<T> aggregation) {
            return new Builder<K, T>((LuceneSearchIndexScope<?>)this.scope, (LuceneSearchIndexValueFieldContext<?>)this.field, LuceneSearchAggregation.from(this.scope, aggregation), this.fromFieldValueConverter, this.order, this.minDocCount, this.maxTermCount);
        }
    }

    private static class CountBuilder<K>
    extends Builder<K, Long> {
        private CountBuilder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<String> field, ProjectionConverter<String, ? extends K> fromFieldValueConverter) {
            super(scope, field, LuceneSearchAggregation.from(scope, LuceneCountDocumentAggregation.factory().create(scope, field).builder().build()), fromFieldValueConverter);
        }
    }

    private static class TypeSelector
    extends AbstractLuceneMultivaluedTermsAggregation.AbstractTypeSelector<String> {
        private TypeSelector(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<String> field) {
            super(scope, field);
        }

        public <K> Builder<K, Long> type(Class<K> expectedType, ValueModel valueModel) {
            if (ValueModel.RAW.equals((Object)valueModel)) {
                return new CountBuilder(this.scope, this.field, this.field.type().rawProjectionConverter().withConvertedType(expectedType, (EventContextProvider)this.field));
            }
            return new CountBuilder(this.scope, this.field, this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, (EventContextProvider)this.field));
        }
    }

    public static class Factory
    extends AbstractLuceneValueFieldSearchQueryElementFactory<TermsAggregationBuilder.TypeSelector, String> {
        @Override
        public TypeSelector create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<String> field) {
            return new TypeSelector(scope, field);
        }
    }
}

