/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.util.Set;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneNestableAggregation;

public abstract class AbstractLuceneMetricNumericLongAggregation
extends AbstractLuceneNestableAggregation<Long> {
    private final Set<String> indexNames;
    private final String absoluteFieldPath;

    AbstractLuceneMetricNumericLongAggregation(AbstractLuceneNestableAggregation.AbstractBuilder<Long> builder) {
        super(builder);
        this.indexNames = builder.scope.hibernateSearchIndexNames();
        this.absoluteFieldPath = builder.field.absolutePath();
    }

    @Override
    public LuceneSearchAggregation.Extractor<Long> request(AggregationRequestContext context) {
        JoiningLongMultiValuesSource source = JoiningLongMultiValuesSource.fromField(this.absoluteFieldPath, this.createNestedDocsProvider(context));
        return new LuceneNumericMetricLongAggregationExtractor(this.fillCollectors(source, context));
    }

    abstract CollectorKey<?, Long> fillCollectors(JoiningLongMultiValuesSource var1, AggregationRequestContext var2);

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    private record LuceneNumericMetricLongAggregationExtractor(CollectorKey<?, Long> collectorKey) implements LuceneSearchAggregation.Extractor<Long>
    {
        @Override
        public Long extract(AggregationExtractContext context) {
            return context.getCollectorResults(this.collectorKey);
        }
    }
}

