/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.aggregation.impl;

import java.io.IOException;
import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.util.common.impl.CollectionHelper;

public interface LuceneSearchAggregation<A>
extends SearchAggregation<A> {
    public Extractor<A> request(AggregationRequestContext var1);

    public Set<String> indexNames();

    public static <A> LuceneSearchAggregation<A> from(LuceneSearchIndexScope<?> scope, SearchAggregation<A> aggregation) {
        if (!(aggregation instanceof LuceneSearchAggregation)) {
            throw QueryLog.INSTANCE.cannotMixLuceneSearchQueryWithOtherAggregations(aggregation);
        }
        LuceneSearchAggregation casted = (LuceneSearchAggregation)aggregation;
        if (!CollectionHelper.isSubset((Set)scope.hibernateSearchIndexNames(), casted.indexNames())) {
            throw QueryLog.INSTANCE.aggregationDefinedOnDifferentIndexes(aggregation, casted.indexNames(), scope.hibernateSearchIndexNames(), CollectionHelper.notInTheOtherSet((Set)scope.hibernateSearchIndexNames(), casted.indexNames()));
        }
        return casted;
    }

    public static interface Extractor<T> {
        public T extract(AggregationExtractContext var1) throws IOException;
    }
}

