/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.util.Collection;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermResults;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TextTermsCollector;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValuesSource;

public class TextTermsCollectorManager
implements CollectorManager<TextTermsCollector, TermResults> {
    private final TextMultiValuesSource valuesSource;
    private final String field;
    private final CollectorKey<?, ?>[] keys;
    private final CollectorManager<Collector, ?>[] managers;

    public TextTermsCollectorManager(String field, TextMultiValuesSource valuesSource, CollectorKey<?, ?>[] keys, CollectorManager<Collector, ?>[] managers) {
        this.field = field;
        this.valuesSource = valuesSource;
        this.keys = keys;
        this.managers = managers;
    }

    public TextTermsCollector newCollector() {
        return new TextTermsCollector(this.field, this.valuesSource, this.keys, this.managers);
    }

    public TermResults reduce(Collection<TextTermsCollector> collection) {
        if (collection.isEmpty()) {
            return TermResults.EMPTY;
        }
        TermResults results = new TermResults(this.keys, this.managers);
        for (TextTermsCollector collector : collection) {
            results.merge(collector.segmentValues());
        }
        return results;
    }
}

