/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.RangeCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.RangeResults;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.EffectiveRange;

public class RangeCollectorManager
implements CollectorManager<RangeCollector, RangeResults> {
    private final LongMultiValuesSource valuesSource;
    private final EffectiveRange[] ranges;
    private final CollectorKey<?, ?>[] keys;
    private final CollectorManager<Collector, ?>[] managers;

    public RangeCollectorManager(LongMultiValuesSource valuesSource, EffectiveRange[] ranges, CollectorKey<?, ?>[] keys, CollectorManager<Collector, ?>[] managers) {
        this.valuesSource = valuesSource;
        this.ranges = ranges;
        this.keys = keys;
        this.managers = managers;
    }

    public RangeCollector newCollector() throws IOException {
        Collector[][] collectors = new Collector[this.keys.length][];
        int index = 0;
        for (CollectorManager<Collector, ?> manager : this.managers) {
            Collector[] c = new Collector[this.ranges.length];
            collectors[index] = c;
            for (int j = 0; j < c.length; ++j) {
                c[j] = manager.newCollector();
            }
            ++index;
        }
        return new RangeCollector(this.valuesSource, this.ranges, collectors, this.keys);
    }

    public RangeResults reduce(Collection<RangeCollector> collection) {
        if (collection.isEmpty()) {
            return RangeResults.EMPTY;
        }
        RangeResults results = new RangeResults(this.keys, this.managers, this.ranges.length);
        for (RangeCollector collector : collection) {
            results.add(collector.collectors());
        }
        return results;
    }
}

