/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.DoubleAggregationFunction;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.DoubleAggregationFunctionCollector;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;

public class DoubleAggregationFunctionCollectorManager<AF extends DoubleAggregationFunction<?>>
implements CollectorManager<DoubleAggregationFunctionCollector<AF>, Double> {
    private final JoiningLongMultiValuesSource source;
    private final Supplier<DoubleAggregationFunction<AF>> functionSupplier;
    private final Function<Long, Double> longToDouble;

    public DoubleAggregationFunctionCollectorManager(JoiningLongMultiValuesSource source, Supplier<DoubleAggregationFunction<AF>> functionSupplier, Function<Long, Double> longToDouble) {
        this.source = source;
        this.functionSupplier = functionSupplier;
        this.longToDouble = longToDouble;
    }

    public DoubleAggregationFunctionCollector<AF> newCollector() {
        return new DoubleAggregationFunctionCollector<AF>(this.source, this.functionSupplier.get(), this.longToDouble);
    }

    public Double reduce(Collection<DoubleAggregationFunctionCollector<AF>> collectors) throws IOException {
        if (collectors.isEmpty()) {
            return null;
        }
        Iterator<DoubleAggregationFunctionCollector<AF>> iterator = collectors.iterator();
        DoubleAggregationFunctionCollector<AF> identity = iterator.next();
        while (iterator.hasNext()) {
            identity.merge(iterator.next());
        }
        return identity.result();
    }
}

