/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValuesSource;

public class CountDistinctTextValuesCollector
extends SimpleCollector {
    private final TextMultiValuesSource source;
    private final String field;
    private TextMultiValues values;
    private final LongHashSet globalOrds = new LongHashSet();
    private LongHashSet leafOrds = new LongHashSet();
    private SortedSetDocValues sortedSetValues;

    public CountDistinctTextValuesCollector(TextMultiValuesSource source, String field) {
        this.source = source;
        this.field = field;
    }

    public void collect(int doc) throws IOException {
        if (this.values.advanceExact(doc)) {
            while (this.values.hasNextValue()) {
                long ord = this.values.nextOrd();
                this.leafOrds.add(ord);
            }
        }
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.initRootSortedSetDocValues((IndexReaderContext)context);
        this.values = this.source.getValues(context);
    }

    public void finish() throws IOException {
        for (LongCursor value : this.leafOrds) {
            long globalOrd = this.sortedSetValues.lookupTerm(this.values.lookupOrd(value.value));
            this.globalOrds.add(globalOrd);
        }
        this.values = null;
        this.leafOrds.clear();
    }

    private void initRootSortedSetDocValues(IndexReaderContext ctx) throws IOException {
        if (this.sortedSetValues != null || ctx == null) {
            return;
        }
        if (ctx.isTopLevel) {
            this.sortedSetValues = MultiDocValues.getSortedSetValues((IndexReader)ctx.reader(), (String)this.field);
        }
        this.initRootSortedSetDocValues((IndexReaderContext)ctx.parent);
    }

    public LongHashSet globalOrds() {
        return this.globalOrds;
    }
}

