/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchScroll;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchScrollResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneExtractableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryIndexScope;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchScrollResultImpl;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public class LuceneSearchScrollImpl<H>
implements LuceneSearchScroll<H> {
    private final LuceneSyncWorkOrchestrator queryOrchestrator;
    private final LuceneWorkFactory workFactory;
    private final LuceneSearchQueryIndexScope<?, ?> scope;
    private final Set<String> routingKeys;
    private final TimeoutManager timeoutManager;
    private final LuceneSearcher<LuceneLoadableSearchResult<H>, LuceneExtractableSearchResult<H>> searcher;
    private final int totalHitCountThreshold;
    private final HibernateSearchMultiReader indexReader;
    private final int chunkSize;
    private int nextChunkOffset = 0;
    private int currentPageLimit;
    private LuceneExtractableSearchResult<H> currentPage;
    private int currentPageOffset = 0;

    public LuceneSearchScrollImpl(LuceneSyncWorkOrchestrator queryOrchestrator, LuceneWorkFactory workFactory, LuceneSearchQueryIndexScope<?, ?> scope, Set<String> routingKeys, TimeoutManager timeoutManager, LuceneSearcher<LuceneLoadableSearchResult<H>, LuceneExtractableSearchResult<H>> searcher, int totalHitCountThreshold, HibernateSearchMultiReader indexReader, int chunkSize) {
        this.queryOrchestrator = queryOrchestrator;
        this.workFactory = workFactory;
        this.scope = scope;
        this.routingKeys = routingKeys;
        this.timeoutManager = timeoutManager;
        this.searcher = searcher;
        this.totalHitCountThreshold = totalHitCountThreshold;
        this.indexReader = indexReader;
        this.chunkSize = chunkSize;
        this.currentPageLimit = chunkSize * 4;
    }

    public void close() {
        try {
            this.indexReader.close();
        }
        catch (IOException | RuntimeException e) {
            LuceneMiscLog.INSTANCE.unableToCloseIndexReader(EventContexts.fromIndexNames((Set)this.scope.hibernateSearchIndexNames()), e);
        }
    }

    public LuceneSearchScrollResult<H> next() {
        this.timeoutManager.start();
        try {
            LuceneSearchScrollResult<H> luceneSearchScrollResult = this.doNext();
            return luceneSearchScrollResult;
        }
        finally {
            this.timeoutManager.stop();
        }
    }

    private LuceneSearchScrollResult<H> doNext() {
        LuceneLoadableSearchResult<H> loadableSearchResult;
        int nextChunkStartIndexInPage;
        if (this.currentPage == null || this.nextChunkOffset + this.chunkSize > this.currentPageLimit + this.currentPageOffset) {
            if (this.currentPage != null) {
                this.currentPageLimit *= 2;
            }
            this.currentPageOffset = this.nextChunkOffset;
            this.currentPage = this.doSubmitWithIndexReader(this.workFactory.scroll(this.searcher, this.currentPageOffset, this.currentPageLimit, this.totalHitCountThreshold), this.indexReader);
        }
        if ((nextChunkStartIndexInPage = this.nextChunkOffset - this.currentPageOffset) >= this.currentPage.hitSize()) {
            return new LuceneSearchScrollResultImpl(this.currentPage.total(), false, Collections.emptyList(), this.timeoutManager.tookTime(), this.timeoutManager.isTimedOut());
        }
        int nextChunkEndIndexInPage = nextChunkStartIndexInPage + this.chunkSize;
        try {
            loadableSearchResult = this.currentPage.extract(nextChunkStartIndexInPage, nextChunkEndIndexInPage);
        }
        catch (IOException e) {
            throw QueryLog.INSTANCE.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), e.getMessage(), EventContexts.fromIndexNames((Set)this.scope.hibernateSearchIndexNames()), e);
        }
        LuceneSearchResult<H> result = loadableSearchResult.loadBlocking();
        this.nextChunkOffset += this.chunkSize;
        return new LuceneSearchScrollResultImpl(this.currentPage.total(), true, result.hits(), result.took(), result.timedOut());
    }

    private <T> T doSubmitWithIndexReader(ReadWork<T> work, HibernateSearchMultiReader indexReader) {
        return this.queryOrchestrator.submit(this.scope.hibernateSearchIndexNames(), this.scope.indexes(), this.routingKeys, work, indexReader);
    }
}

