/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Collection;
import java.util.Map;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.search.extraction.impl.ExtractionRequirements;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.query.spi.QueryParameters;

public final class ProjectionRequestContext {
    private final ExtractionRequirements.Builder extractionRequirementsBuilder;
    private final String absoluteCurrentNestedFieldPath;
    private final String absoluteCurrentFieldPath;
    private final LuceneAbstractSearchHighlighter globalHighlighter;
    private final Map<String, LuceneAbstractSearchHighlighter> namedHighlighters;
    private final QueryParameters parameters;

    public ProjectionRequestContext(ExtractionRequirements.Builder extractionRequirementsBuilder, LuceneAbstractSearchHighlighter globalHighlighter, Map<String, LuceneAbstractSearchHighlighter> namedHighlighters, QueryParameters parameters) {
        this(extractionRequirementsBuilder, globalHighlighter, namedHighlighters, parameters, null, null);
    }

    private ProjectionRequestContext(ExtractionRequirements.Builder extractionRequirementsBuilder, LuceneAbstractSearchHighlighter globalHighlighter, Map<String, LuceneAbstractSearchHighlighter> namedHighlighters, QueryParameters parameters, String absoluteCurrentFieldPath, String absoluteCurrentNestedFieldPath) {
        this.extractionRequirementsBuilder = extractionRequirementsBuilder;
        this.globalHighlighter = globalHighlighter;
        this.namedHighlighters = namedHighlighters;
        this.parameters = parameters;
        this.absoluteCurrentNestedFieldPath = absoluteCurrentNestedFieldPath;
        this.absoluteCurrentFieldPath = absoluteCurrentFieldPath;
    }

    public void requireAllStoredFields() {
        this.extractionRequirementsBuilder.requireAllStoredFields();
    }

    public void requireNestedObjects(Collection<String> paths) {
        this.extractionRequirementsBuilder.requireNestedObjects(paths);
    }

    public void requireStoredField(String absoluteFieldPath, String nestedDocumentPath) {
        this.extractionRequirementsBuilder.requireStoredField(absoluteFieldPath, nestedDocumentPath);
    }

    public void requireScore() {
        this.extractionRequirementsBuilder.requireScore();
    }

    public void checkValidField(String absoluteFieldPath) {
        if (!FieldPaths.isStrictPrefix((String)this.absoluteCurrentNestedFieldPath, (String)absoluteFieldPath)) {
            throw QueryLog.INSTANCE.invalidContextForProjectionOnField(absoluteFieldPath, this.absoluteCurrentNestedFieldPath);
        }
    }

    void checkNotNested(SearchQueryElementTypeKey<?> projectionKey, String hint) {
        if (this.absoluteCurrentFieldPath() != null) {
            throw QueryLog.INSTANCE.cannotUseProjectionInNestedContext(projectionKey.toString(), hint, EventContexts.indexSchemaRoot());
        }
    }

    public ProjectionRequestContext root() {
        return new ProjectionRequestContext(this.extractionRequirementsBuilder, this.globalHighlighter, this.namedHighlighters, this.parameters);
    }

    public ProjectionRequestContext forField(String absoluteFieldPath, boolean nestedObject) {
        this.checkValidField(absoluteFieldPath);
        return new ProjectionRequestContext(this.extractionRequirementsBuilder, this.globalHighlighter, this.namedHighlighters, this.parameters, absoluteFieldPath, nestedObject ? absoluteFieldPath : this.absoluteCurrentFieldPath);
    }

    public String absoluteCurrentNestedFieldPath() {
        return this.absoluteCurrentNestedFieldPath;
    }

    public boolean projectionCardinalityCorrectlyAddressed(String requiredContextAbsoluteFieldPath) {
        String absoluteCurrentNestedFieldPath = this.absoluteCurrentNestedFieldPath();
        return requiredContextAbsoluteFieldPath == null || requiredContextAbsoluteFieldPath.equals(absoluteCurrentNestedFieldPath) || absoluteCurrentNestedFieldPath != null && absoluteCurrentNestedFieldPath.startsWith(requiredContextAbsoluteFieldPath + ".");
    }

    public String absoluteCurrentFieldPath() {
        return this.absoluteCurrentFieldPath;
    }

    public LuceneAbstractSearchHighlighter highlighter(String name) {
        if (name == null) {
            return this.globalHighlighter == null ? LuceneAbstractSearchHighlighter.defaultHighlighter() : this.globalHighlighter;
        }
        LuceneAbstractSearchHighlighter highlighter = this.namedHighlighters.get(name);
        if (highlighter == null) {
            throw QueryLog.INSTANCE.cannotFindHighlighterWithName(name, this.namedHighlighters.keySet());
        }
        return highlighter;
    }

    public NamedValues queryParameters() {
        return this.parameters;
    }
}

