/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.impl;

import java.io.InputStream;
import org.apache.lucene.util.ResourceLoader;
import org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoaderHelper;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;

final class HibernateSearchResourceLoader
implements ResourceLoader {
    private final ClassResolver classResolver;
    private final ResourceResolver resourceResolver;

    HibernateSearchResourceLoader(ClassResolver classResolver, ResourceResolver resourceResolver) {
        this.classResolver = classResolver;
        this.resourceResolver = resourceResolver;
    }

    public InputStream openResource(String resource) {
        InputStream inputStream = this.resourceResolver.locateResourceStream(resource);
        if (inputStream == null) {
            throw LuceneMiscLog.INSTANCE.unableToLoadResource(resource);
        }
        return inputStream;
    }

    public <T> Class<? extends T> findClass(String className, Class<T> expectedType) {
        return ClassLoaderHelper.classForName(expectedType, (String)className, (ClassResolver)this.classResolver);
    }

    public <T> T newInstance(String className, Class<T> expectedType) {
        return (T)ClassLoaderHelper.instanceFromName(expectedType, (String)className, (ClassResolver)this.classResolver);
    }
}

