/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.ChildDocIds;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.engine.search.projection.ProjectionCollector;

abstract class AbstractNestingAwareAccumulatingValues<E, A>
implements Values<A> {
    private final NestedDocsProvider nestedDocsProvider;
    protected final ProjectionCollector<E, ?, A, ?> collector;
    protected ChildDocIds currentLeafChildDocIds;

    AbstractNestingAwareAccumulatingValues(String parentDocumentPath, String nestedDocumentPath, ProjectionCollector<E, ?, A, ?> collector, TopDocsDataCollectorExecutionContext context) {
        this.nestedDocsProvider = nestedDocumentPath == null || nestedDocumentPath.equals(parentDocumentPath) ? null : context.createNestedDocsProvider(parentDocumentPath, nestedDocumentPath);
        this.collector = collector;
    }

    @Override
    public void context(LeafReaderContext context) throws IOException {
        DocIdSetIterator valuesOrNull = this.doContext(context);
        if (this.nestedDocsProvider != null) {
            this.currentLeafChildDocIds = this.nestedDocsProvider.childDocs(context, valuesOrNull);
        }
    }

    protected DocIdSetIterator doContext(LeafReaderContext context) throws IOException {
        return null;
    }

    @Override
    public final A get(int parentDocId) throws IOException {
        Object accumulated = this.collector.createInitial();
        if (this.nestedDocsProvider == null) {
            accumulated = this.accumulate(accumulated, parentDocId);
            return (A)accumulated;
        }
        if (this.currentLeafChildDocIds == null) {
            return (A)accumulated;
        }
        if (!this.currentLeafChildDocIds.advanceExactParent(parentDocId)) {
            return (A)accumulated;
        }
        int currentChildDocId = this.currentLeafChildDocIds.nextChild();
        while (currentChildDocId != Integer.MAX_VALUE) {
            accumulated = this.accumulate(accumulated, currentChildDocId);
            currentChildDocId = this.currentLeafChildDocIds.nextChild();
        }
        return (A)accumulated;
    }

    protected abstract A accumulate(A var1, int var2) throws IOException;
}

